unit uprobu;

// Copyright  2002 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls;

type
  TUserProbForm = class(TForm)
    Label1    : TLabel;
    Label2    : TLabel;
    Label3    : TLabel;
    ListBox1  : TListBox;
    btnOK     : TButton;
    btnCancel : TButton;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function GetString : String;
  end;

var
  UserProbForm: TUserProbForm;

implementation

uses SuperReg, autoShar;

{$R *.dfm}

const
  ProKey : String = 'SOFTWARE\Microsoft\Protected Storage System '+
    'Provider';

procedure TUserProbForm.FormCreate(Sender: TObject);
VAR
  TS    : TStringList;
  TempS : TStringList;
  N     : Integer;
begin
  TS := TStringList.Create;
  try
    WITH TSuperReg.Create DO
    try
      Rootkey := HKEY_LOCAL_MACHINE;
      IF OpenKeyReadOnly(ProKey) THEN
        GetKeyNames(TS);
      FOR N := TS.Count-1 DOWNTO 0 DO
        IF NOT (OpenKeyReadOnly(Format('\'+regKey, [TS[N]])) AND
          HasSubKeys) THEN
            TS.Delete(N);
      //IE6 under Win9x puts it here?
      Rootkey := HKEY_CURRENT_USER;
      IF OpenKeyReadOnly(ProKey) THEN
        begin
          TempS := TStringList.Create;
          try
            GetKeyNames(TempS);
            FOR N := TempS.Count-1 DOWNTO 0 DO
              IF NOT (OpenKeyReadOnly(Format('\'+regKey, [TempS[N]]))
                AND HasSubKeys) THEN
                  TempS.Delete(N);
            TS.Duplicates := dupIgnore;
            TS.Sorted     := True;
            TS.AddStrings(TempS);
            TS.Sorted     := False;
            TS.Duplicates := dupAccept;
          finally
            TempS.Free;
          end;
        end;
      FOR N := TS.Count-1 DOWNTO 0 DO
        IF TS[N]= '' THEN TS.Delete(N);
      ListBox1.Items.Assign(TS);
      IF ListBox1.Items.Count > 0 THEN
        begin
          ListBox1.ItemIndex := 0;
          btnOK.Enabled      := True;
        end;
    finally
      Free;
    end;
  finally
    TS.Free;
  end;
end;

function TUserProbForm.GetString: String;
begin
  IF ListBox1.ItemIndex >= 0 THEN
    Result := ListBox1.Items[ListBox1.ItemIndex]
  ELSE
    Result := '';
end;

end.
