unit testu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Button2: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }

  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses autoShar;

{$R *.dfm}

function GetNTUserName(szUser: PChar; var cchUser: DWORD): BOOL;
VAR
  ptokUser : Pointer{PTOKEN_USER};
  hToken   : THANDLE;
  cbTokUser : DWORD;
  cchDomain : DWORD;
  sidNameUse : SID_NAME_USE;
  szDomain : ARRAY[0..499] OF Char;
  hPRocessTray : THandle;
  dwTray : DWORD;
  hWndTray : HWND;
  bRet : Bool;
begin
  ptokUser := nil;
  hToken := 0;
  cbTokUser := 0;
  bRet := False;
  cchDomain := 500;
  try
    // Find the tray's window and get its process handle
    hWndTray := FindWindow('Shell_TrayWnd',nil);
    hWndTray := GetDesktopWindow;
    GetWindowThreadProcessId(hWndTray,dwTray);
//    hProcessTray := OpenProcess(PROCESS_ALL_ACCESS,FALSE,dwTray);
    hProcessTray := OpenProcess(PROCESS_QUERY_INFORMATION,FALSE,dwTray);
    // Retrieve the process token
    IF NOT OpenProcessToken(hProcessTray,TOKEN_QUERY,hToken) THEN
      Exit;
    // Find out how much space we need to store the user's info
    IF GetTokenInformation(hToken,TokenUser,nil,0,cbTokUser) THEN
      Exit // should not happen
    ELSE IF GetLastError() <> ERROR_INSUFFICIENT_BUFFER THEN
      Exit;
    // Allocate some space for our user info
    ptokUser := HeapAlloc(GetProcessHeap(),0,cbTokUser);
    IF NOT Assigned(ptokUser) THEN Exit;
    // Get the user token info
    IF NOT GetTokenInformation(hToken,TokenUser,ptokUser,cbTokUser,cbTokUser) THEN
      Exit;
    // Get the user name and domain from the user's SID

    IF NOT LookupAccountSid(nil, ptokUser,szUser,cchUser,
                            szDomain,cchDomain,sidNameUse) THEN
        Exit;
    bRet := TRUE;
  finally
    // Free resources.
    IF hToken <> 0 THEN CloseHandle(hToken);
    IF hProcessTray <> 0 THEN CloseHandle(hProcessTray);
    IF ptokUser <> nil THEN
      HeapFree(GetProcessHeap(),0,ptokUser);
  end;
end;


procedure TForm1.Button1Click(Sender: TObject);
VAR S : String;
begin
  CASE CurrentUserSid(S) OF
    cus_OK                        : Edit1.Text := S;
    cus_GetUserName               : Label1.Caption := 'GetUserName               failed';
    cus_LookupAccountName         : Label1.Caption := 'LookupAccountName         failed';
    cus_GetSidIdentifierAuthority : Label1.Caption := 'GetSidIdentifierAuthority failed';
    cus_GetSidSubAuthorityCount   : Label1.Caption := 'GetSidSubAuthorityCount   failed';
    cus_GetSidSubAuthority        : Label1.Caption := 'GetSidSubAuthority        failed';
  END;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  PutShared(ChangeFileExt(Application.Exename, '.$$$'));
  Edit1.Text := GetShared.SID;
  CASE StartAndStop OF
    sands_OK           : Label1.Caption := 'OK';
    sands_scmfailed    : Label1.Caption := 'SCM failed';
    sands_openfailed   : Label1.Caption := 'Open failed';
    sands_startfailed  : Label1.Caption := 'Start failed';
    sands_stopfailed   : Label1.Caption := 'Stop failed';
  end;
end;


end.
