program test95a;

{$APPTYPE CONSOLE}


uses
  SysUtils,
  StrUtils,
  Windows,
  Registry,
  Classes,
  SuperReg in '..\themecrafter\SuperReg.pas';

VAR
  T  : TextFile;

procedure Writ(const S : String);
begin
  WriteLn(S);
  WriteLn(T, S);
end;

const
  RegKey : String = '\SOFTWARE\Microsoft\Protected Storage System Pr'+
    'ovider\%s\Data\e161255a-37c3-11d2-bcaa-00c04fd929db\e161255a-3'+
    '7c3-11d2-bcaa-00c04fd929db';
  RegKey2 : String = '\SOFTWARE\Microsoft\Protected Storage System Provider';
  ukey : String = '\Software\Microsoft\Windows\CurrentVersion\Network\Real Mode Net';

procedure Analyze(const S : String; isLM : Boolean);
VAR
  TS : TStringList;
  N, Fo, Pa : Integer;
begin
  WITH TSuperReg.Create DO
  try
    IF isLM THEN RootKey := HKEY_LOCAL_MACHINE
    ELSE         RootKey := HKEY_CURRENT_USER;
    IF OpenKey(Format(RegKey, [S]), False) THEN
      begin
        TS := TStringList.Create;
        try
          GetKeyNames(TS);
          Fo := 0; Pa := 0;
          FOR N := 0 TO TS.Count-1 DO
            begin
              IF Pos(':StringData', TS[N]) = 0 THEN Continue;
              IF Pos('http:', TS[N]) = 0 THEN Inc(fo)
              ELSE Inc(pa);
            end;
        finally
          TS.Free;
        end;
        Writ(Format(#9'%d entries for Form AutoComplete', [fo]));
        Writ(Format(#9'%d entries for Password AutoComplete', [pa]));
      end;
  finally
    Free;
  end;
end;

procedure NewTry;
VAR
  TempS, Users : TStringList;
  N            : Integer;
begin
  TempS := TStringList.Create;
  Users := TStringList.Create;
  try
    WITH TSuperReg.Create DO
    try
      RootKey := HKEY_LOCAL_MACHINE;
      IF OpenKeyReadOnly(uKey) THEN
        begin
          IF ValueExists('AutoLogon') THEN
            begin
              Writ(Format('AutoLogon=%d',
                [ReadIntegerSafe('AutoLogon',-1)]));
            end
          ELSE Writ('AutoLogon value''s key exists, but value does not');
        end
      ELSE Writ('AutoLogOn value''s key not present');
      Writ(StringOfChar('=', 40));
      RootKey := HKEY_LOCAL_MACHINE;
      IF OpenKeyReadOnly(RegKey2) THEN
        begin
          GetKeyNames(TempS);
          FOR N := 0 TO TempS.Count-1 DO
            begin
              Writ(Format('%s (%s)',[TempS[N], 'HKLM']));
              Analyze(TempS[N], True);
              Users.AddObject(TempS[N], Pointer(1));
            end;
        end;
      RootKey := HKEY_CURRENT_USER;
      IF OpenKeyReadOnly(RegKey2) THEN
        begin
          GetKeyNames(TempS);
          FOR N := 0 TO TempS.Count-1 DO
            begin
              Writ(Format('%s (%s)',[TempS[N], 'HKCU']));
              Analyze(TempS[N], False);
              Users.AddObject(TempS[N], Pointer(2));
            end;
        end;
    finally
      Free;
    end;
  finally
    Users.Free;
    TempS.Free;
  end;
end;


begin
  AssignFile(T, ChangeFileExt(ParamStr(0), '.TXT'));
  Rewrite(T);
  try
    NewTry;
  finally
    CloseFile(T);
  end;
end.
