program sidtest;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  Windows,
  Classes, // for TStringList
  Registry;

const
  cus_OK                        = 0;
  cus_GetUserName               = -1;
  cus_LookupAccountName         = -2;
  cus_GetSidIdentifierAuthority = -3;
  cus_GetSidSubAuthorityCount   = -4;
  cus_GetSidSubAuthority        = -5;
  cus_GetShareFailed            = -6;


type
  TOKEN_USER = packed record
    User : TSidAndAttributes;
  end;
  PTOKEN_USER = ^TOKEN_USER;

VAR
  SIDBUFF : ARRAY[0..1000] OF Byte;
  T : TextFile;

procedure Writ(const S : String);
begin
  WriteLn(S);
  WriteLn(T, S);
end;

function CurrentUserSIDBreak(VAR theSID : String) : Integer;
// The old CurrentUserSID function came up with the wrong SID on
// some systems. No idea exactly why, but this function works
// better.
VAR
  hProcess, hAccessToken : THandle;
  dwSIDSize : DWORD;
  Sid       : PSid;
  PSIA     : PSIDIdentifierAuthority;
  N        : Integer;
  NumSubs  : PUChar;
  OneSub   : PDWORD;

begin
  Writ('Breakdown of CurrentUserSID function');
  Result   := -1;
  hProcess := 0;
  hAccessToken := 0;
  FillChar(SIDBUFF, SizeOf(SIDBUFF), 0);
  hProcess := GetCurrentProcess;
  IF NOT OpenProcessToken(hProcess, TOKEN_READ, hAccessToken) THEN
    Exit;
  Result := -2;
  dwSidSize := SizeOf(SIDBUFF);
  IF NOT GetTokenInformation(hAccessToken, TokenUser, @SIDBUFF,
    SizeOf(SIDBUFF), dwSIDSize) THEN Exit;
  Result := -3;
  TheSid := 'S-1-';
  SetLastError(0);
  Sid := PToken_User(@SIDBUFF).User.SID;
  IF NOT IsValidSid(Sid) THEN
    Exit;
  PSIA := GetSidIdentifierAuthority(sid);
  IF GetLastError <> 0 THEN
    Exit;
  WITH PSIA^ do
    IF (Value[0]<>0) OR (Value[1]<>0) THEN
      TheSid := Format('%s0x%.2x%.2x%.2x%.2x%.2x%.2x-',
        [TheSid, Value[0], Value[1], Value[2], Value[3],
        Value[4], Value[5]])
    else
      begin
        N := Value[2] SHL 8;
        N := (N + Value[3]) SHL 8;
        N := (N + Value[4]) SHL 8;
        N := N + Value[5];
        TheSid := Format('%s%d', [TheSid, N]);
      end;
  Result  := cus_GetSidSubAuthorityCount;
  NumSubs := GetSidSubAuthorityCount(sid);

  Writ(Format('Number of sub-authorities: %d',[NumSubs^]));
  IF GetLastError <> 0 THEN
    Exit;
  FOR N := 0 TO NumSubs^-1 DO
    begin
      Result := cus_GetSidSubAuthority;
      OneSub := GetSidSubAuthority(sid, N);
      Writ(Format('Sub#%d, Pointer:%p, Value:%u',[N, OneSub, OneSub^]));
      IF GetLastError <> 0 THEN
        Exit;
      TheSid := Format('%s-%u', [TheSid, OneSub^]);
      Writ('Sid so far: ' + TheSid);
    end;
  Result := cus_OK;
end;



function CurrentUserSID(VAR theSID : String) : Integer;
// The old CurrentUserSID function came up with the wrong SID on
// some systems. No idea exactly why, but this function works
// better.
VAR
  hProcess, hAccessToken : THandle;
  dwSIDSize : DWORD;
  Sid       : PSid;
  PSIA     : PSIDIdentifierAuthority;
  N        : Integer;
  NumSubs  : PUChar;
  OneSub   : PDWORD;
begin
  Result   := -1;
  hProcess := 0;
  hAccessToken := 0;
  FillChar(SIDBUFF, SizeOf(SIDBUFF), 0);
  hProcess := GetCurrentProcess;
  IF NOT OpenProcessToken(hProcess, TOKEN_READ, hAccessToken) THEN
    Exit;
  Result := -2;
  dwSidSize := SizeOf(SIDBUFF);
  IF NOT GetTokenInformation(hAccessToken, TokenUser, @SIDBUFF,
    SizeOf(SIDBUFF), dwSIDSize) THEN Exit;
  Result := -3;
  TheSid := 'S-1-';
  SetLastError(0);
  Sid := PToken_User(@SIDBUFF).User.SID;
  IF NOT IsValidSid(Sid) THEN
    Exit;
  PSIA := GetSidIdentifierAuthority(sid);
  IF GetLastError <> 0 THEN
    Exit;
  WITH PSIA^ do
    IF (Value[0]<>0) OR (Value[1]<>0) THEN
      TheSid := Format('%s0x%.2x%.2x%.2x%.2x%.2x%.2x-',
        [TheSid, Value[0], Value[1], Value[2], Value[3],
        Value[4], Value[5]])
    else
      begin
        N := Value[2] SHL 8;
        N := (N + Value[3]) SHL 8;
        N := (N + Value[4]) SHL 8;
        N := N + Value[5];
        TheSid := Format('%s%d', [TheSid, N]);
      end;
  Result  := cus_GetSidSubAuthorityCount;
  NumSubs := GetSidSubAuthorityCount(sid);
  IF GetLastError <> 0 THEN
    Exit;
  FOR N := 0 TO NumSubs^-1 DO
    begin
      Result := cus_GetSidSubAuthority;
      OneSub := GetSidSubAuthority(sid, N);
      IF GetLastError <> 0 THEN
        Exit;
      TheSid := Format('%s-%u', [TheSid, OneSub^]);
    end;
  Result := cus_OK;
end;

function CurrentUserSIDOld(VAR theSID : String) : Integer;
// Calculate the Security ID for the current user, to
//  determine which branch of HKEY_USERS is HKEY_CURRENT_USER
VAR
  UserName : ARRAY[0..MAX_PATH] OF Char;
  UserLeng : DWORD;
  DomaName : ARRAY[0..MAX_PATH] OF Char;
  DomaLeng : DWORD;
  SID      : ARRAY[0..1000] OF Byte;
  SIDLeng  : DWORD;
  SIDuse   : DWORD;
  PSIA     : PSIDIdentifierAuthority;
  N        : Integer;
  NumSubs  : PUChar;
  OneSub   : PDWORD;
begin
  UserLeng := MAX_PATH;
  Result   := cus_GetUserName;
  IF NOT GetUserName(UserName, UserLeng) THEN
    Exit;
  DomaLeng := MAX_PATH;
  Result   := cus_LookupAccountName;
  SidLeng  := 1000;
  IF NOT LookupAccountName(NIL, UserName, @SID, SIDLeng,
    DomaName, DomaLeng, SidUse) THEN
    Exit;
  TheSid := 'S-1-';
  Result := cus_GetSidIdentifierAuthority;
  SetLastError(0);
  PSIA := GetSidIdentifierAuthority(@SID);
  IF GetLastError <> 0 THEN
    Exit;
  WITH PSIA^ do
    IF (Value[0]<>0) OR (Value[1]<>0) THEN
      TheSid := Format('%s0x%.2x%.2x%.2x%.2x%.2x%.2x-',
        [TheSid, Value[0], Value[1], Value[2], Value[3],
        Value[4], Value[5]])
    else
      begin
        N := Value[2] SHL 8;
        N := (N + Value[3]) SHL 8;
        N := (N + Value[4]) SHL 8;
        N := N + Value[5];
        TheSid := Format('%s%d', [TheSid, N]);
      end;
  Result  := cus_GetSidSubAuthorityCount;
  NumSubs := GetSidSubAuthorityCount(@SID);
  IF GetLastError <> 0 THEN
    Exit;
  FOR N := 0 TO NumSubs^-1 DO
    begin
      Result := cus_GetSidSubAuthority;
      OneSub := GetSidSubAuthority(@SID, N);
      IF GetLastError <> 0 THEN
        Exit;
      TheSid := Format('%s-%u', [TheSid, OneSub^]);
    end;
  Result := cus_OK;
end;

VAR
  Sid1, Sid2 : String;
  OK1, OK2 : Boolean;
  N : Integer;
  Keys     : TStringList;
const
  OKS : ARRAY[Boolean] OF String = (' - bad', ' - GOOD');
begin
  Writ('1.0.7.0');
  AssignFile(T, ChangeFileExt(ParamStr(0), '.TXT'));
  Rewrite(T);
  CurrentUserSidBreak(Sid1);
  Writ(StringOfChar('=', 62));
  try
    CurrentUserSidOld(Sid1);
    CurrentUserSid(Sid2);
    Keys := TStringList.Create;
    try
      WITH TRegistry.Create DO
      try
        RootKey := HKEY_USERS;
        IF OpenKeyReadOnly('') THEN
          GetKeyNames(Keys);
        OK1 := OpenKeyReadOnly('\'+Sid1);
        OK2 := OpenKeyReadOnly('\'+Sid2);
      finally
        Free;
      end;
      Writ('Old way: '+ Sid1+ oks[OK1]);
      Writ('New way: '+ Sid2+ oks[OK2]);
      Writ(StringOfChar('=', 62));
      Writ('SIDs found in HKEY_USERS:');
      FOR N := 0 TO Keys.Count-1 DO
        Writ(#9+Keys[N]);
    finally
      Keys.Free;
    end;
  finally
    CloseFile(T);
  end;
end.
