unit mainu;

// Copyright  2002 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, AppEvnts, ComCtrls, StdCtrls, CheckLst, ExtCtrls;

type
  TMainForm = class(TForm)
    pmMain        : TPopupMenu;
      popHelp     : TMenuItem;
    Label1        : TLabel;
    pnlOldIE      : TPanel;
    lbMain        : TCheckListBox;
    btnConfigure  : TButton;
    btnChange     : TButton;
    btnCkAll      : TButton;
    btnClAll      : TButton;
    btnRefresh    : TButton;
    btnHelp       : TButton;
    btnAbout      : TButton;
    btnClose      : TButton;
    sbMain        : TStatusBar;
    aeMain        : TApplicationEvents;
    procedure FormCreate        (Sender: TObject);
    procedure FormDestroy       (Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure lbMainClickCheck  (Sender: TObject);
    procedure lbMainDblClick    (Sender: TObject);
    procedure lbMainDragOver    (Sender, Source: TObject;
      X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure btnConfigureClick (Sender: TObject);
    procedure btnChangeClick    (Sender: TObject);
    procedure btnCkClearClick   (Sender: TObject);
    procedure btnRefreshClick   (Sender: TObject);
    procedure btnHelpClick      (Sender: TObject);
    procedure btnAboutClick     (Sender: TObject);
    procedure btnCloseClick     (Sender: TObject);
    procedure aeMainHint        (Sender: TObject);
  private
    { Private declarations }
    first       : Boolean; // Used in FormActivate
    IEMajor     : DWord;   // Major version for Internet Explorer
    IEMinor     : DWord;   // Minor version for Internet Explorer
    helpname    : String;  // Name of HTMLHelp file
    ServiceName : String;  // Full pathname for autoserv.exe
    tempPath    : String;  // The system's TEMP path
    tempFiles   : TStringList; // List of AutoWhat's HTML files
    procedure LoadList;
    function AnyChecked : Boolean;
    function StartAndStop : Integer;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation
uses Registry, ShellApi, AboutBox, allfuncs, shlobj, WinSvc,
  formposu, autoShar, hapi, strUtils, uprobu, inifiles;
{$R *.DFM}

const
  // Constants for StartAndStop function
  sands_OK          = 0;
  sands_scmfailed   = -1;
  sands_openfailed  = -2;
  sands_startfailed = -3;
  sands_stopfailed  = -4;


  // AutoWhat?'s test page is built using these strings of HTML
  templateHead : String =
    '<HTML>'+
    '<HEAD>'+
    '<TITLE>AutoWhat? Test Page </TITLE>'+
    '</HEAD>'+
    '<BODY>'+
    '<H1 ALIGN="CENTER">AutoWhat? Test Page</H1>'+
    '<P>AutoComplete values for fields in Web-based forms are '+
    'tied to the internal field name. The table below lists '+
    'the selected internal field names for which AutoComplete '+
    'values have been recorded.</P>'+
    '<UL>'+
    '<LI>To see the drop-down list of AutoComplete values for '+
    'a particular field name, click in the blank input field next '+
    'to it and press the down arrow key. </LI>'+
    '<LI>To delete one of these entries, highlight it in the '+
    'drop-down list and press the Del key. </LI>'+
    '<LI>To add a new value to the list for a particular '+
    'field name, type it into the adjacent input field and '+
    'click Post or press Enter.</LI>'+
    '<LI>You can add multiple items for a given field name '+
    'by repeating this process.</LI>'+
    '</UL>'+
    '<FORM>'+
    '<INPUT TYPE="submit" NAME="Submit" VALUE="Post"><BR><BR>'+
    '<TABLE BORDER="1" RULES="ROWS" CELLPADDING="2">'+
    '<TR>'+
    '<TH NOWRAP="NOWRAP" ALIGN="LEFT">Internal field names</TH>'+
    '<TH NOWRAP="NOWRAP" ALIGN="LEFT">Input fields</TH>'+
    '</TR>';
  templateLine : String =
    '<TR>'+
    '<TD NOWRAP="NOWRAP">%s</TD>'+
    '<TD NOWRAP="NOWRAP"><INPUT NAME="%0:s" SIZE="50"></TD>'+
    '</TR>';
  templateFoot : String =
    '</TABLE>'+
    '<BR>'+
    '<INPUT TYPE="submit" NAME="Submit" VALUE="Post">&nbsp;'+
    '</FORM>'+
    '<HR SIZE=3>'+
    '<FONT SIZE="2">AutoWhat? Copyright &copy; 1999, 2002 by '+
    'Ziff Davis Media, Inc.<BR>All Rights Reserved<BR></FONT>'+
    '<FONT SIZE="1">Written by Neil J. Rubenking<BR>'+
    'First published in <A HREF="http://www.pcmag.com">'+
    'PC Magazine, U.S. Edition</A>, March 26, 2002.</FONT>'+
    '</BODY>'+
    '</HTML>';


procedure TMainForm.FormCreate(Sender: TObject);
begin
  first       := True; // FormActivate includes code to execute
                       // only on the first activation.
  SetLength(TempPath, MAX_PATH);
  SetLength(TempPath, GetTempPath(MAX_PATH, PChar(TempPath)));
  TempPath := FinalSlash(TempPath);
  TempFiles   := TStringList.Create;
  GetPosFmExeName(Application.ExeName, Self, True);
  HelpName    := ChangeFileExt(Application.Exename, '.chm');
  // ServiceName is the full pathname for autoserv.exe
  ServiceName := ExtractFileDir(Application.Exename)+'\AutoServ.exe';
end;

procedure TMainForm.FormDestroy(Sender: TObject);
VAR N : Integer;
begin
  // Delete any temporary files that AutoWhat? has created
  FOR N := 0 TO TempFiles.Count-1 DO
    DeleteFile(TempFiles[N]);
  TempFiles.Free;
  SetPosToExeName(Application.ExeName, Self, True);
end;

procedure TMainForm.FormActivate(Sender: TObject);
  procedure GetIEVersion;
  type
    PDllVersionInfo = ^TDllVersionInfo;
    TDllVersionInfo = record
      cbSize          : DWORD;
      dwMajorVersion  : DWORD;
      dwMinorVersion  : DWORD;
      dwBuildNumber   : DWORD;
      dwPlatformID    : DWORD;
    end;
    DllGetVersionType = function (pdvi : PDllVersionInfo) :
      HRESULT; stdcall;
  VAR
    LibH           : hModule;
    DllGetVersion  : DllGetVersionType;
    DVI            : TDllVersionInfo;
  begin
    IEMajor := 0;
    IEMinor := 0;
    LibH   := LoadLibrary('shlwapi.dll');
    IF LibH <= 32 THEN Exit;
    try
      @DllGetVersion := GetProcAddress(LibH, 'DllGetVersion');
      IF @DllGetVersion = nil THEN Exit;
      FillChar(DVI, SizeOf(DVI), 0);
      DVI.cbSize := SizeOf(DVI);
      IF DllGetVersion(@DVI) = NOERROR THEN
        begin
          IEMajor := DVI.dwMajorVersion;
          IEMinor := DVI.dwMinorVersion;
        end;
    finally
      FreeLibrary(LibH);
    end;
  end;

begin
  // It may take a noticeable time to load the list of AutoComplete
  // field names, so instead of doing it in FormCreate, we do it in
  // FormActivate *after* calling Show. FormActivate can be triggered
  // separately from the initial display, so we use the First
  // variable to make sure we don't initialize twice.
  IF NOT First THEN Exit;
  First := False;
  Show;
  btnCkAll.Enabled     := False;
  btnClAll.Enabled     := False;
  btnRefresh.Enabled   := False;
  btnConfigure.Enabled := False;
  Application.ProcessMessages;
  GetIEVersion;
  // If it's an old version of Internet Explorer, show the message
  // about how you need IE5 or later
  IF IEMajor < 5 THEN
    begin
      pnlOldIE.Height := lbMain.Height;
      pnlOldIE.Width  := lbMain.Width;
      lbMain.Visible  := False;
      pnlOldIE.BringToFront;
    end
  ELSE           
    begin
      pnlOldIE.Free;
      LoadList;
      btnConfigure.Enabled := True;
    end;
end;

procedure TMainForm.FormMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
// This enables flyover hints for disabled buttons
VAR
  P : TPoint;
  N : Integer;
begin
  P := Point(X,Y);
  WITH Sender AS TWinControl DO
    begin
      Hint := '';
      FOR N := 0 TO ControlCount-1 DO
        IF Controls[N] IS TWinControl THEN
          IF PtInRect(TWinControl(Controls[N]).BoundsRect, P) THEN
            Hint := TWinControl(Controls[N]).Hint;
      IF Hint = '' THEN
        Application.CancelHint;
    end;
end;

procedure TMainForm.lbMainClickCheck(Sender: TObject);
// Called when the user clicks a checkmark.
begin
  btnChange.Enabled := AnyChecked;
end;

procedure TMainForm.lbMainDblClick(Sender: TObject);
// Toggle checked state upon double-click
begin
  WITH Sender AS TCheckListBox DO
    IF ItemIndex > -1 THEN
      Checked[ItemIndex] := NOT Checked[ItemIndex];
  btnChange.Enabled := AnyChecked;
end;

procedure TMainForm.lbMainDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
// This method causes items in the list to be checked if you click
// on any item and drag along
VAR Idx : Integer;
begin
  Accept := Sender=Source;
  WITH Sender AS TCheckListBox DO
    begin
      Idx := ItemAtPos(Point(X,Y), True);
      IF Idx > -1 THEN
        begin
          Checked[Idx]      := True;
          ItemIndex         := Idx;
          btnChange.Enabled := True;
        end;
    end;
end;

procedure TMainForm.btnConfigureClick(Sender: TObject);
// Attempt to open the Internet Options dialog, select the Content
// tab, and as-if-click the AutoComplete... button. If this fails,
// tell the user what to do.
VAR
  hDial : HWnd; // handle to Internet Options dialog
  hTab  : HWnd; // handle to Content tab
  hButn : HWnd; // handle to AutoComplete... button
  ID, N : Integer;
const
  // Content is the 4th tab in IE6, the 3rd in IE5
  cmds : ARRAY[boolean] OF PChar =
    ('rundll32.exe shell32.dll,Control_RunDLL inetcpl.cpl,@0,2',
     'rundll32.exe shell32.dll,Control_RunDLL inetcpl.cpl,@0,3');
begin
  WinExec(cmds[IEMajor >= 6], SW_SHOWMINIMIZED);
  N := 0;
  REPEAT
    hDial := FindWindow('#32770', 'Internet Properties');
    Inc(N);
    Sleep(200);
    Application.ProcessMessages;
  UNTIL (hDial <> 0) OR (N > 20);
  IF hDial = 0 THEN
    begin
      MessageBox(Handle, 'AutoWhat? was unable to launch the '+
        'AutoComplete dialog. Please launch Internet Options '+
        'from Control Panel (or from IE''s Tools menu), click '+
        'the Content tab, and click the AutoComplete... button.',
        'AutoWhat?', MB_OK OR
        MB_ICONINFORMATION);
      Exit;
    end;
  hTab := FindWindowEx(hDial, 0, '#32770', 'Content');
  hButn := FindWindowEx(hTab, 0, 'Button', 'A&utoComplete...');
  IF (hTab = 0) OR (hButn = 0) THEN
    begin
      MessageBox(Handle, 'AutoWhat? was unable to launch the '+
        'AutoComplete dialog. The Internet Options dialog should '+
        'be visible. Please click the Content tab, and click the '+
        'AutoComplete... button.', 'AutoWhat?', MB_OK OR
        MB_ICONINFORMATION);
      Exit;
    end;
  ID := GetDlgCtrlID(hButn);
  PostMessage(hDial, WM_COMMAND, ID, hButn);
end;

procedure TMainForm.btnChangeClick(Sender: TObject);
VAR
  fn : String;
  T  : TextFile;
  N  : Integer;

  function GetTempHTMName : String;
  // Get a temporary filename based on the last 32 bits of the
  // current time. In the unlikely event that the filename
  // already exists, keep trying
  begin
    REPEAT
      Result := Format('%sauto%.04x.htm', [TempPath,
        GetTickCount AND $FFFF]);
    UNTIL NOT FileExists(Result);
  end;

begin
  Screen.Cursor := crAppStart;
  try
    fn := GetTempHTMName;
    tempFiles.Add(fn);
    AssignFile(T, fn);
    Rewrite(T);
    try
      WriteLn(T, TemplateHead);
      FOR N := 0 TO lbMain.Items.Count-1 DO
        IF lbMain.Checked[N] THEN
          WriteLn(T, Format(templateLine, [lbMain.Items[N]]));
      WriteLn(T, TemplateFoot);
    finally
      CloseFile(T);
    end;
    ShellExecute(Self.Handle, nil, PChar(fn), nil, nil, SW_RESTORE);
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TMainForm.btnCkClearClick(Sender: TObject);
// Check all or none, depending if tag is 1 or 0
VAR N : Integer;
begin
  WITH Sender AS TButton DO
    begin
      FOR N := 0 TO lbMain.Items.Count-1 DO
        lbMain.Checked[N] := Tag=1;
      btnChange.Enabled := (lbMain.Items.Count > 0) AND (Tag=1);
    end;
end;

procedure TMainForm.btnRefreshClick(Sender: TObject);
begin
  LoadList;
end;

procedure TMainForm.btnHelpClick(Sender: TObject);
begin
  IF HtmlHelp(Handle, PChar(HelpName),0,0) = HWnd(-1) THEN
    MessageBox(Handle, 'AutoWhat? failed to invoke HtmlHelp',
      'AutoWhat?', MB_OK OR MB_ICONSTOP);
end;

procedure TMainForm.btnAboutClick(Sender: TObject);
begin
  WITH TAboutForm.Create(Self) DO
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TMainForm.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.aeMainHint(Sender: TObject);
begin
  sbMain.SimpleText := Application.Hint;
end;

procedure TMainForm.LoadList;
VAR
  TS        : TStringList;
  N, P, Idx : Integer;
  TimeOut   : Boolean;

  procedure ReadRegNT;
  VAR N : Integer;
  begin
    PutShared;
    IF StartAndStop <> sands_OK THEN
      begin
        MessageBox(Handle, 'AutoWhat? was unable to activate its '+
          'helper service. You may have accidentally un-registered '+
          'the service.'#13#10#13#10'When you click OK, AutoWhat? '+
          'will attempt to re-register the service. If you see '+
          'the message "Service installed successfully", just '+
          'click Refresh list in the main window. If '+
          'not, please run the AutoWhat? install program '+
          'again.', 'AutoWhat?', MB_OK OR MB_ICONSTOP);
          WinExec(PChar(ServiceName+' /install'), SW_MINIMIZE);
      end
    ELSE
      begin
        // Watch for the "finished" key to appear, up to 5 seconds
        FOR N := 1 TO 50 DO
          begin
            TimeOut := False;
            WITH TRegistry.Create DO
            try
              RootKey := HKEY_LOCAL_MACHINE;
              IF KeyExists(fromKey+'\AutoServFinished') THEN Break;
            finally
              Free;
            end;
            Sleep(100);
            Application.ProcessMessages;
            TimeOut := True;
          end;
        IF TimeOut THEN
          MessageBox(Handle, 'AutoWhat? waited five seconds for a '+
            'completion signal from AutoServ, but never received '+
            'it. Your list of AutoComplete fields may not be '+
            'complete.', 'AutoWhat?', MB_OK OR MB_ICONINFORMATION);
        WITH TRegistry.Create DO
        try
          Rootkey := HKEY_LOCAL_MACHINE;
          IF OpenKey(fromKey, False) THEN
            begin
              GetKeyNames(TS);
              CloseKey;
              DeleteKey(fromKey);
            end;
        finally;
          Free;
        end;
      end;
  end;

  procedure CheckUserName(VAR UserName : String);
  VAR
    ininame : String;
    gotname : String;

    function FoundName(const S : String) : Boolean;
    begin
      IF S = '' THEN Result := False
      ELSE
        WITH TRegistry.Create DO
        try
          Result := True;
          // If the username is non blank AND the corresponding
          // key exists, all is well.
          RootKey := HKEY_LOCAL_MACHINE;
          IF OpenKey(Format(RegKey, [S]), False) THEN Exit;
          RootKey := HKEY_CURRENT_USER;
          IF OpenKey(Format(RegKey, [S]), False) THEN Exit;
          Result := False;
        finally
          Free;
        end;
    end;

  begin
    IF FoundName(UserName) THEN Exit;
    ininame := ChangeFileExt(Application.Exename, '.INI');
    WITH TIniFile.Create(ininame) DO
    try
      gotname := ReadString('Advanced Settings', 'Username', '');
    finally
      Free;
    end;
    IF FoundName(gotName) THEN
      begin
        UserName := GotName;
        Exit;
      end;
    WITH TUserProbForm.Create(Self) DO
    try
      IF ShowModal = mrOK THEN
        UserName := GetString
      ELSE UserName := '';
    finally
      Free;
    end;
    IF UserName <> '' THEN
    WITH TIniFile.Create(ininame) DO
    try
      WriteString('Advanced Settings', 'Username', UserName);
    finally
      Free;
    end;
  end;

  procedure ReadReg9x;
  VAR
    nSize    : Cardinal;
    buffer   : ARRAY[0..MAX_PATH] OF Char;
    UserName : String;
    TempS    : TStringList;
  begin
    nSize := MAX_PATH;
    GetuserName(buffer, nSize);
    UserName := Strpas(Buffer);
    CheckUserName(UserName);
    IF UserName = '' THEN
      MessageBox(Handle, 'AutoWhat? is unable to obtain your '+
        'username, and cannot proceed.', 'AutoWhat?', MB_OK OR
        MB_ICONSTOP);
    WITH TRegistry.Create DO
    try
      Rootkey := HKEY_LOCAL_MACHINE;
      IF OpenKey(Format(RegKey, [UserName]), False) THEN
        GetKeyNames(TS);
      //IE6 under Win9x puts it here?
      Rootkey := HKEY_CURRENT_USER;
      IF OpenKey(Format(RegKey, [UserName]), False) THEN
        begin
          TempS := TStringList.Create;
          try
            GetKeyNames(TempS);
            TS.Duplicates := dupIgnore;
            TS.Sorted := True;
            TS.AddStrings(TempS);
            TS.Sorted := False;
            TS.Duplicates := dupAccept;
          finally
            TempS.Free;
          end;
        end;
    finally
      Free;
    end;
  end;

begin
  lbMain.Enabled       := False;
  btnRefresh.Enabled   := False;
  btnChange.Enabled    := False;
  btnCkAll.Enabled     := False;
  btnClAll.Enabled     := False;

  TS := TStringList.Create;
  Screen.Cursor := crHourglass;
  try
    IF Win32Platform = VER_PLATFORM_WIN32_NT THEN
      ReadRegNT
    ELSE
      ReadReg9x;
    // TS now contains the names of all subkeys of the AutoComplete
    // key. Those ending in ":StringData" are useful. Discard any
    // others, and trim off ":StringData" from the keepers.
    FOR N := TS.Count-1 DOWNTO 0 DO
      begin
        Application.ProcessMessages;
        P := Pos(':StringData', TS[N]);
        IF (P = 0) OR (Pos('/', TS[N]) <> 0) THEN
          TS.Delete(N)
        ELSE TS[N] := Copy(TS[N], 1, P-1);
      end;
    //Save checked/unchecked status from listbox
    FOR N := 0 TO TS.Count-1 DO
      begin
        P := lbMain.Items.IndexOf(TS[N]);
        IF P < 0 THEN Continue;
        IF lbMain.Checked[P] THEN
          TS.Objects[N] := Pointer(1);
      end;
    Idx := lbMain.ItemIndex;
    // Transfer the new list to the listbox
    lbMain.Clear;
    lbMain.Items.AddStrings(TS);
    // Restore checked/unchecked status
    FOR N := 0 TO lbMain.Items.Count-1 DO
      lbMain.Checked[N] :=
        (lbMain.Items.Objects[N] = Pointer(1));
    IF Idx >= lbMain.Items.Count THEN Idx := lbMain.Items.Count-1;
    lbMain.ItemIndex   := Idx;
    btnCkAll.Enabled   := lbMain.Items.Count > 0;
    btnClAll.Enabled   := lbMain.Items.Count > 0;
    btnChange.Enabled  := AnyChecked;
    lbMain.Enabled     := True;
    btnRefresh.Enabled := True;
  finally
    TS.Free;
    Screen.Cursor := crDefault;
    lbMain.ItemIndex := -1;
  end;
end;

function TMainForm.AnyChecked: Boolean;
// True if any checked items in lbMain
VAR N : Integer;
begin
  Result := False;
  FOR N := 0 TO lbMain.Items.Count-1 DO
    IF lbMain.Checked[N] THEN
      begin
        Result := True;
        Break;
      end;
end;

function TMainForm.StartAndStop : Integer;
// The easy way to get a rise out of our service is just to start
// and stop it

  function StartSvc : Integer;
  VAR
    SCM             : SC_HANDLE;
    ourService      : SC_HANDLE;
    P               : PChar;
    lpServiceStatus : _SERVICE_STATUS;
  begin
    SCM := OpenSCManager(nil, nil, SC_MANAGER_CONNECT);
    Result := sands_scmfailed;
    IF SCM = 0 THEN Exit;
    try
      ourService := OpenService(SCM, 'AutoWhatService',
        SERVICE_START OR SERVICE_STOP);
      Result := sands_openfailed;
      IF ourService = 0 THEN Exit;
      try
        Result := sands_startfailed;
        IF NOT StartService(ourService, 0, P) THEN Exit;
        // Service has started - now wait until its status is no
        // longer "start pending"
        REPEAT
          ControlService(ourService, SERVICE_CONTROL_INTERROGATE,
            lpServiceStatus);
        UNTIL lpServiceStatus.dwCurrentState AND
          SERVICE_START_PENDING = 0;
        // Wait a moment longer
        Sleep(100);
        result := sands_OK;
      finally
        CloseServiceHandle(ourService);
      end;
    finally
      CloseServiceHandle(SCM);
    end;
  end;

  function StopSvc : Integer;
  VAR
    SCM             : SC_HANDLE;
    ourService      : SC_HANDLE;
    lpServiceStatus : _SERVICE_STATUS;
  begin
    SCM := OpenSCManager(nil, nil, SC_MANAGER_CONNECT);
    Result := sands_scmfailed;
    IF SCM = 0 THEN Exit;
    try
      ourService := OpenService(SCM, 'AutoWhatService',
        SERVICE_START OR SERVICE_STOP);
      Result := sands_openfailed;
      IF ourService = 0 THEN Exit;
      try
        Result := sands_stopfailed;
        IF NOT ControlService(ourService, SERVICE_CONTROL_STOP,
          lpServiceStatus) THEN Exit;
        result := sands_OK;
      finally
        CloseServiceHandle(ourService);
      end;
    finally
      CloseServiceHandle(SCM);
    end;
  end;

begin
  // Stop the service if it's already running
  StopSvc;
  // Start it and...
  Result := StartSvc;
  // ... if successful, stop it
  IF Result = sands_OK THEN
    Result := StopSvc;
end;

end.



