unit hapi;

// Copyright  2002 by Ziff Davis Media, Inc.
// Translated to Delphi from Microsoft's htmlhelp.h
//   by Neil J. Rubenking

// As it turns out, the program for which this translation was made
// doesn't use anything but a simple call to HtmlHelp. Thus most of
// the various constants and data types have not actually been
// subjected to real-world testing.

interface
USES Windows, SysUtils;

function HtmlHelp(hWndCaller: hWnd; pszFile: PChar; uCommand: UInt;
  dwdata: DWORD): hWnd;
VAR
  HHCtrlVersion : Int64 = 0; // The version data for HHCTRL.OCX,
                             // packed into a 64-bit value
  HHVersion : DWORD  = 0; // Major and minor version of HtmlHelp,
                          // packed into a DWORD, calculated from
                          // the HHCtrlVersion

const
// Commands to pass to HtmlHelp()

  HH_DISPLAY_TOPIC        = $0000;
  HH_HELP_FINDER          = $0000;  // WinHelp equivalent
  HH_DISPLAY_TOC          = $0001;
  HH_DISPLAY_INDEX        = $0002;
  HH_DISPLAY_SEARCH       = $0003;
  HH_SET_WIN_TYPE         = $0004;
  HH_GET_WIN_TYPE         = $0005;
  HH_GET_WIN_HANDLE       = $0006;
  HH_ENUM_INFO_TYPE       = $0007;  // Get Info type name, call repeatedly to enumerate, -1 at end
  HH_SET_INFO_TYPE        = $0008;  // Add Info type to filter.
  HH_SYNC                 = $0009;
  HH_RESERVED1            = $000A;
  HH_RESERVED2            = $000B;
  HH_RESERVED3            = $000C;
  HH_KEYWORD_LOOKUP       = $000D;
  HH_DISPLAY_TEXT_POPUP   = $000E;  // display string resource id or text in a popup window
  HH_HELP_CONTEXT         = $000F;  // display mapped numeric value in dwData
  HH_TP_HELP_CONTEXTMENU  = $0010;  // text popup help, same as WinHelp HELP_CONTEXTMENU
  HH_TP_HELP_WM_HELP      = $0011;  // text popup help, same as WinHelp HELP_WM_HELP
  HH_CLOSE_ALL            = $0012;  // close all windows opened directly or indirectly by the caller
  HH_ALINK_LOOKUP         = $0013;  // ALink version of HH_KEYWORD_LOOKUP
  HH_GET_LAST_ERROR       = $0014;  // not currently implemented // See HHERROR.h
  HH_ENUM_CATEGORY        = $0015;	// Get category name, call repeatedly to enumerate, -1 at end
  HH_ENUM_CATEGORY_IT     = $0016;  // Get category info type members, call repeatedly to enumerate, -1 at end
  HH_RESET_IT_FILTER      = $0017;  // Clear the info type filter of all info types.
  HH_SET_INCLUSIVE_FILTER = $0018;  // set inclusive filtering method for untyped topics to be included in display
  HH_SET_EXCLUSIVE_FILTER = $0019;  // set exclusive filtering method for untyped topics to be excluded from display
  HH_INITIALIZE           = $001C;  // Initializes the help system.
  HH_UNINITIALIZE         = $001D;  // Uninitializes the help system.
  HH_PRETRANSLATEMESSAGE  = $00fd;  // Pumps messages. (NULL, NULL, MSG*).
  HH_SET_GLOBAL_PROPERTY  = $00fc;  // Set a global property. (NULL, NULL, HH_GPROP)

  HHWIN_PROP_TAB_AUTOHIDESHOW =1 SHL 0;    // Automatically hide/show tri-pane window
  HHWIN_PROP_ONTOP            =1 SHL 1;    // Top-most window
  HHWIN_PROP_NOTITLEBAR       =1 SHL 2;    // no title bar
  HHWIN_PROP_NODEF_STYLES     =1 SHL 3;    // no default window styles =only HH_WINTYPE.dwStyles;
  HHWIN_PROP_NODEF_EXSTYLES   =1 SHL 4;    // no default extended window styles =only HH_WINTYPE.dwExStyles;
  HHWIN_PROP_TRI_PANE         =1 SHL 5;    // use a tri-pane window
  HHWIN_PROP_NOTB_TEXT        =1 SHL 6;    // no text on toolbar buttons
  HHWIN_PROP_POST_QUIT        =1 SHL 7;    // post WM_QUIT message when window closes
  HHWIN_PROP_AUTO_SYNC        =1 SHL 8;    // automatically ssync contents and index
  HHWIN_PROP_TRACKING         =1 SHL 9;    // send tracking notification messages
  HHWIN_PROP_TAB_SEARCH       =1 SHL 10;   // include search tab in navigation pane
  HHWIN_PROP_TAB_HISTORY      =1 SHL 11;   // include history tab in navigation pane
  HHWIN_PROP_TAB_FAVORITES    =1 SHL 12;   // include favorites tab in navigation pane
  HHWIN_PROP_CHANGE_TITLE     =1 SHL 13;   // Put current HTML title in title bar
  HHWIN_PROP_NAV_ONLY_WIN     =1 SHL 14;   // Only display the navigation window
  HHWIN_PROP_NO_TOOLBAR       =1 SHL 15;   // Don't display a toolbar
  HHWIN_PROP_MENU             =1 SHL 16;   // Menu
  HHWIN_PROP_TAB_ADVSEARCH    =1 SHL 17;   // Advanced FTS UI.
  HHWIN_PROP_USER_POS         =1 SHL 18;   // After initial creation, user controls window size/position
  HHWIN_PROP_TAB_CUSTOM1      =1 SHL 19;   // Use custom tab #1
  HHWIN_PROP_TAB_CUSTOM2      =1 SHL 20;   // Use custom tab #2
  HHWIN_PROP_TAB_CUSTOM3      =1 SHL 21;   // Use custom tab #3
  HHWIN_PROP_TAB_CUSTOM4      =1 SHL 22;   // Use custom tab #4
  HHWIN_PROP_TAB_CUSTOM5      =1 SHL 23;   // Use custom tab #5
  HHWIN_PROP_TAB_CUSTOM6      =1 SHL 24;   // Use custom tab #6
  HHWIN_PROP_TAB_CUSTOM7      =1 SHL 25;   // Use custom tab #7
  HHWIN_PROP_TAB_CUSTOM8      =1 SHL 26;   // Use custom tab #8
  HHWIN_PROP_TAB_CUSTOM9      =1 SHL 27;   // Use custom tab #9
  HHWIN_TB_MARGIN             =1 SHL 28;   // the window type has a margin

  HHWIN_PARAM_PROPERTIES      =1 SHL 1;    // valid fsWinProperties
  HHWIN_PARAM_STYLES          =1 SHL 2;    // valid dwStyles
  HHWIN_PARAM_EXSTYLES        =1 SHL 3;    // valid dwExStyles
  HHWIN_PARAM_RECT            =1 SHL 4;    // valid rcWindowPos
  HHWIN_PARAM_NAV_WIDTH       =1 SHL 5;    // valid iNavWidth
  HHWIN_PARAM_SHOWSTATE       =1 SHL 6;    // valid nShowState
  HHWIN_PARAM_INFOTYPES       =1 SHL 7;    // valid apInfoTypes
  HHWIN_PARAM_TB_FLAGS        =1 SHL 8;    // valid fsToolBarFlags
  HHWIN_PARAM_EXPANSION       =1 SHL 9;    // valid fNotExpanded
  HHWIN_PARAM_TABPOS          =1 SHL 10;   // valid tabpos
  HHWIN_PARAM_TABORDER        =1 SHL 11;   // valid taborder
  HHWIN_PARAM_HISTORY_COUNT   =1 SHL 12;   // valid cHistory
  HHWIN_PARAM_CUR_TAB         =1 SHL 13;   // valid curNavType

  HHWIN_BUTTON_EXPAND         =1 SHL 1;    // Expand/contract button
  HHWIN_BUTTON_BACK           =1 SHL 2;    // Back button
  HHWIN_BUTTON_FORWARD        =1 SHL 3;    // Forward button
  HHWIN_BUTTON_STOP           =1 SHL 4;    // Stop button
  HHWIN_BUTTON_REFRESH        =1 SHL 5;    // Refresh button
  HHWIN_BUTTON_HOME           =1 SHL 6;    // Home button
  HHWIN_BUTTON_BROWSE_FWD     =1 SHL 7;    // not implemented
  HHWIN_BUTTON_BROWSE_BCK     =1 SHL 8;    // not implemented
  HHWIN_BUTTON_NOTES          =1 SHL 9;    // not implemented
  HHWIN_BUTTON_CONTENTS       =1 SHL 10;   // not implemented
  HHWIN_BUTTON_SYNC           =1 SHL 11;   // Sync button
  HHWIN_BUTTON_OPTIONS        =1 SHL 12;   // Options button
  HHWIN_BUTTON_PRINT          =1 SHL 13;   // Print button
  HHWIN_BUTTON_INDEX          =1 SHL 14;   // not implemented
  HHWIN_BUTTON_SEARCH         =1 SHL 15;   // not implemented
  HHWIN_BUTTON_HISTORY        =1 SHL 16;   // not implemented
  HHWIN_BUTTON_FAVORITES      =1 SHL 17;   // not implemented
  HHWIN_BUTTON_JUMP1          =1 SHL 18;
  HHWIN_BUTTON_JUMP2          =1 SHL 19;
  HHWIN_BUTTON_ZOOM           =1 SHL 20;
  HHWIN_BUTTON_TOC_NEXT       =1 SHL 21;
  HHWIN_BUTTON_TOC_PREV       =1 SHL 22;
  HHWIN_DEF_BUTTONS           =
            (HHWIN_BUTTON_EXPAND  OR
             HHWIN_BUTTON_BACK    OR
             HHWIN_BUTTON_OPTIONS OR
             HHWIN_BUTTON_PRINT);

// Button IDs

 IDTB_EXPAND             = 200;
 IDTB_CONTRACT           = 201;
 IDTB_STOP               = 202;
 IDTB_REFRESH            = 203;
 IDTB_BACK               = 204;
 IDTB_HOME               = 205;
 IDTB_SYNC               = 206;
 IDTB_PRINT              = 207;
 IDTB_OPTIONS            = 208;
 IDTB_FORWARD            = 209;
 IDTB_NOTES              = 210; // not implemented
 IDTB_BROWSE_FWD         = 211;
 IDTB_BROWSE_BACK        = 212;
 IDTB_CONTENTS           = 213; // not implemented
 IDTB_INDEX              = 214; // not implemented
 IDTB_SEARCH             = 215; // not implemented
 IDTB_HISTORY            = 216; // not implemented
 IDTB_FAVORITES          = 217; // not implemented
 IDTB_JUMP1              = 218;
 IDTB_JUMP2              = 219;
 IDTB_CUSTOMIZE          = 221;
 IDTB_ZOOM               = 222;
 IDTB_TOC_NEXT           = 223;
 IDTB_TOC_PREV           = 224;

// Notification codes

 HHN_FIRST       = -860;
 HHN_LAST        = -879;

 HHN_NAVCOMPLETE   = HHN_FIRST-0;
 HHN_TRACK         = HHN_FIRST-1;
 HHN_WINDOW_CREATE = HHN_FIRST-2;

type
  PHHNNotify = ^THHNNotify;
  tagHHN_NOTIFY = packed record
    hdr : TNMHDR;
    pszUrl : PChar;
  end;
  HHN_NOTIFY = tagHHN_NOTIFY;
  THHNNotify = tagHHN_NOTIFY;

  PHHPopup = ^THHPopup;
  tagHH_POPUP = packed record
    cbStruct      : Integer;  // sizeof this structure
    hinst         : HINST;    // instance handle for string resource
    idString      : UINT;     // string resource id, or text id if pszFile is specified in HtmlHelp call
    pszText       : PChar;    // used if idString is zero
    pt            : TPoint;   // top center of popup window
    clrForeground : COLORREF; // use -1 for default
    clrBackground : COLORREF; // use -1 for default
    rcMargins     : TRECT;    // amount of space between edges of window and text, -1 for each member to ignore
    pszFont       : PChar;    // facename, point size, char set, BOLD ITALIC UNDERLINE
  end;
  HH_POPUP = tagHH_POPUP;
  THHPopup = tagHH_POPUP;

  PHHAKLink = ^THHAKLink;
  tagHH_AKLINK = packed record
    cbStruct     : Integer;   // sizeof this structure
    fReserved    : BOOL;      // must be FALSE (really!)
    pszKeywords  : PChar;     // semi-colon separated keywords
    pszUrl       : PChar;     // URL to jump to if no keywords found (may be NULL)
    pszMsgText   : PChar;     // Message text to display in MessageBox if pszUrl is NULL and no keyword match
    pszMsgTitle  : PChar;     // Message text to display in MessageBox if pszUrl is NULL and no keyword match
    pszWindow    : PChar;     // Window to display URL in
    fIndexOnFail : BOOL;      // Displays index if keyword lookup fails.
  end;
  HH_AKLINK = tagHH_AKLINK;
  THHAKLink = tagHH_AKLINK;

  HHWIN_NAVTYPE_ =
    (HHWIN_NAVTYPE_TOC,
    HHWIN_NAVTYPE_INDEX,
    HHWIN_NAVTYPE_SEARCH,
    HHWIN_NAVTYPE_FAVORITES,
    HHWIN_NAVTYPE_HISTORY,   // not implemented
    HHWIN_NAVTYPE_AUTHOR,
    HHWIN_NAVTYPE_CUSTOM_FIRST = 11);

  IT_ =
    (IT_INCLUSIVE,
    IT_EXCLUSIVE,
    IT_HIDDEN);


  PHHEnumIT = ^THHEnumIT;
  tagHH_ENUM_IT = packed record
     cbStruct         : Integer;    // size of this structure
     iType            : Integer;    // the type of the information type ie. Inclusive, Exclusive, or Hidden
     pszCatName       : PChar;      // Set to the name of the Category to enumerate the info types in a category else NULL
     pszITName        : PChar;      // volitile pointer to the name of the infotype. Allocated by call. Caller responsible for freeing
     pszITDescription : PChar;      // volitile pointer to the description of the infotype.
  end;
  THHEnumIT = tagHH_ENUM_IT;

  PHHEnumCat = ^THHEnumCat;
  tagHH_ENUM_CAT = packed record
    cbStruct          : Integer;   // size of this structure
    pszCatName        : PChar;     // volitile pointer to the category name
    pszCatDescription : PChar;     // volitile pointer to the category description
  end;
  THHEnumCat = tagHH_ENUM_CAT;

  PHHSetInfoType = ^THHSetInfoType;
  tagHH_SET_INFOTYPE = packed record
    cbStruct        : Integer;   // the size of this structure
    pszCatName      : PChar;     // the name of the category, if any, the InfoType is a member of.
    pszInfoTypeName : PChar;     // the name of the info type to add to the filter
  end;
  THHSetInfoType = tagHH_SET_INFOTYPE;

  HH_INFOTYPE = DWORD;
  THHInfoType = HH_INFOTYPE;
  PHHInfoType = ^THHInfoType;

  HHWIN_NAVTAB_ = (
    HHWIN_NAVTAB_TOP,
    HHWIN_NAVTAB_LEFT,
    HHWIN_NAVTAB_BOTTOM);

const
  HH_MAX_TABS = 19;  // maximum number of tabs

type
  HH_TAB_ =
    (HH_TAB_CONTENTS,
    HH_TAB_INDEX,
    HH_TAB_SEARCH,
    HH_TAB_FAVORITES,
    HH_TAB_HISTORY,
    HH_TAB_AUTHOR,

    HH_TAB_CUSTOM_FIRST = 11,
    HH_TAB_CUSTOM_LAST = HH_MAX_TABS);

const
  HH_MAX_TABS_CUSTOM = (Ord(HH_TAB_CUSTOM_LAST) -
    Ord(HH_TAB_CUSTOM_FIRST) + 1);

// HH_DISPLAY_SEARCH Command Related Structures and Constants

  HH_FTS_DEFAULT_PROXIMITY = (-1);

type
  PHHFtsQuery = ^THHFtsQuery;
  tagHH_FTS_QUERY = packed record
    cbStruct        : Integer; // Sizeof structure in bytes.
    fUniCodeStrings : BOOL;    // TRUE if all strings are unicode.
    pszSearchQuery  : PChar;   // String containing the search query.
    iProximity      : LongInt; // Word proximity.
    fStemmedSearch  : BOOL;    // TRUE for StemmedSearch only.
    fTitleOnly      : BOOL;    // TRUE for Title search only.
    fExecute        : BOOL;    // TRUE to initiate the search.
    pszWindow       : PChar;   // Window to display in
  end;
  THHFtsQuery = tagHH_FTS_QUERY;

// HH_WINTYPE Structure

  PHHWinType = ^THHWinType;
  tagHH_WINTYPE = packed record
    cbStruct        : Integer; // IN: size of this structure including all Information Types
    fUniCodeStrings : BOOL;    // IN/OUT: TRUE if all strings are in UNICODE
    pszType         : PChar;   // IN/OUT: Name of a type of window
    fsValidMembers  : DWORD;   // IN: Bit flag of valid members (HHWIN_PARAM_)
    fsWinProperties : DWORD;   // IN/OUT: Properties/attributes of the window (HHWIN_)

    pszCaption      : PChar;   // IN/OUT: Window title
    dwStyles        : DWORD;   // IN/OUT: Window styles
    dwExStyles      : DWORD;   // IN/OUT: Extended Window styles
    rcWindowPos     : TRECT;   // IN: Starting position, OUT: current position
    nShowState      : Integer; // IN: show state (e.g., SW_SHOW)

    hwndHelp        : HWND;    // OUT: window handle
    hwndCaller      : HWND;    // OUT: who called this window

    paInfoTypes     : PHHInfoType;  // IN: Pointer to an array of Information Types

    // The following members are only valid if HHWIN_PROP_TRI_PANE is set

    hwndToolBar    : HWND;    // OUT: toolbar window in tri-pane window
    hwndNavigation : HWND;    // OUT: navigation window in tri-pane window
    hwndHTML       : HWND;    // OUT: window displaying HTML in tri-pane window
    iNavWidth      : Integer; // IN/OUT: width of navigation window
    rcHTML         : TRECT;   // OUT: HTML window coordinates

    pszToc         : PChar;   // IN: Location of the table of contents file
    pszIndex       : PChar;   // IN: Location of the index file
    pszFile        : PChar;   // IN: Default location of the html file
    pszHome        : PChar;   // IN/OUT: html file to display when Home button is clicked
    fsToolBarFlags : DWORD;   // IN: flags controling the appearance of the toolbar
    fNotExpanded   : BOOL;    // IN: TRUE/FALSE to contract or expand, OUT: current state
    curNavType     : Integer; // IN/OUT: UI to display in the navigational pane
    tabpos         : Integer; // IN/OUT: HHWIN_NAVTAB_TOP, HHWIN_NAVTAB_LEFT, or HHWIN_NAVTAB_BOTTOM
    idNotify       : Integer; // IN: ID to use for WM_NOTIFY messages
    tabOrder: packed array[0..HH_MAX_TABS] of Byte;  // IN/OUT: tab order: Contents, Index, Search, History, Favorites, Reserved 1-5, Custom tabs

    cHistory       : Integer;  // IN/OUT: number of history items to keep (default is 30)
    pszJump1       : PChar;    // Text for HHWIN_BUTTON_JUMP1
    pszJump2       : PChar;    // Text for HHWIN_BUTTON_JUMP2
    pszUrlJump1    : PChar;    // URL for HHWIN_BUTTON_JUMP1
    pszUrlJump2    : PChar;    // URL for HHWIN_BUTTON_JUMP2
    rcMinSize      : TRECT;    // Minimum size for window (ignored in version 1)
    cbInfoTypes    : Integer;  // size of paInfoTypes
    pszCustomTabs  : PChar;    // multiple zero-terminated strings
  end;
  HH_WINTYPE = tagHH_WINTYPE;
  THHWinType = tagHH_WINTYPE;

   HHACT_TAB_ =
    (HHACT_TAB_CONTENTS,
    HHACT_TAB_INDEX,
    HHACT_TAB_SEARCH,
    HHACT_TAB_HISTORY,
    HHACT_TAB_FAVORITES,

    HHACT_EXPAND,
    HHACT_CONTRACT,
    HHACT_BACK,
    HHACT_FORWARD,
    HHACT_STOP,
    HHACT_REFRESH,
    HHACT_HOME,
    HHACT_SYNC,
    HHACT_OPTIONS,
    HHACT_PRINT,
    HHACT_HIGHLIGHT,
    HHACT_CUSTOMIZE,
    HHACT_JUMP1,
    HHACT_JUMP2,
    HHACT_ZOOM,
    HHACT_TOC_NEXT,
    HHACT_TOC_PREV,
    HHACT_NOTES,

    HHACT_LAST_ENUM);

  PHHNTrack = ^THHNTrack;
  tagHHNTRACK = packed record
    hdr: TNMHDR;
    pszCurUrl  : PChar;      // Multi-byte, null-terminated string
    idAction   : Integer;    // HHACT_ value
    phhWinType : PHHWinType; // Current window type structure
  end;
  HHNTRACK = tagHHNTRACK;
  THHNTrack = tagHHNTRACK;

// Use the following for GetProcAddress to load from hhctrl.ocx
const
  ATOM_HTMLHELP_API_ANSI    = 14;
  ATOM_HTMLHELP_API_UNICODE = 15;

///////////////////////////////////////////////////////////////////////////////
//
// Global Control Properties. 
//
type
  tagHH_GPROPID =
    (HH_GPROPID_SINGLETHREAD=1,      // VARIANT_BOOL: True for single thread
    HH_GPROPID_TOOLBAR_MARGIN=2,    // long: Provides a left/right margin around the toolbar.
    HH_GPROPID_UI_LANGUAGE=3,       // long: LangId of the UI.
    HH_GPROPID_CURRENT_SUBSET=4,    // BSTR: Current subset.
    HH_GPROPID_CONTENT_LANGUAGE=5); // long: LandId for desired content.
  HH_GPROPID = tagHH_GPROPID;
  THHGPropID = HH_GPROPID;

///////////////////////////////////////////////////////////////////////////////
//
// Global Property structure
//

  PHHGlobalProperty = ^THHGlobalProperty;
  tagHH_GLOBAL_PROPERTY = record                  //tagHH_GLOBAL_PROPERTY, HH_GLOBAL_PROPERTY
    id:                THHGPropID;
    Dummy:             Integer;                  // Added to enforce 8-byte packing
    var_:              VARIANT;
  end;
  HH_GLOBAL_PROPERTY = tagHH_GLOBAL_PROPERTY;
  THHGlobalProperty = tagHH_GLOBAL_PROPERTY;


implementation
USES Registry;
type
  HtmlHelpType = function(hWndCaller: hWnd; pszFile: PAnsiChar;
    uCommand: UInt; dwdata: DWORD): hWnd; stdcall;
VAR
  HHLibHandle : THandle = 0;
  _HtmlHelp : HtmlHelpType = nil;

function HtmlHelp(hWndCaller: hWnd; pszFile: PChar; uCommand: UInt;
  dwdata: DWORD): hWnd;
// A wrapper for the actual HtmlHelp function, which may not be
// available. If available, call it. If not, return -1.
begin
  Result := HWnd(-1);
  IF @_HtmlHelp = nil THEN Exit;
  Result  := _HtmlHelp(hWndCaller, pszFile, uCommand, dwData);
end;

procedure InitializeHH;
VAR
  filename : String;
  Dummy    : DWord;
  VerSize  : DWord;
  Buffer   : Pointer;
  FFInfo   : PVSFixedFileInfo;
  FFLen    : Cardinal;

  function LocateHHCTrlOCX : String;
  begin
    Result := '';
    WITH TRegistry.Create DO
    try
      RootKey := HKEY_CLASSES_ROOT;
      IF OpenKeyReadOnly('CLSID\{adb880a6-d8ff-11cf-9377-00aa003b7a11'+
        '}\InprocServer32') THEN
        Result := ReadString('');
    finally
      free;
    end;
    IF Result = '' THEN
      begin
        SetLength(Result, MAX_PATH);
        SetLength(Result, GetSystemDirectory(PChar(Result), MAX_PATH));
        IF Result <> '' THEN
          begin
            IF Result[Length(Result)] <> '\' THEN
              Result := Result + '\';
            Result := Result + 'hhctrl.ocx';
          end;
      end;
    IF NOT FileExists(Result) THEN Result := '';
  end;

  function Translate(I : Int64) : DWORD;
    //  1.0   is   4.72.7290 - IE4
    //  1.1   is   4.72.7323
    //  1.1a  is  4.72.7325 - Windows98
    //  1.1b  is  4.72.8164 - MSDN
    //  1.2   is   4.73.8252 - Adds extra search control & Favorites tab
    //  1.21  is  4.73.8412 - Bug fixes
    //  1.21a is 4.73.8474 - Quick update to fix FTS on CDROM
    //  1.22  is  4.73.8561 - This release fixes three bugs in 1.21a that caused problems for Arabic, Hebrew, and Far East languages.
    //  1.3   is   4.74.8702 - Win2000 Unicode support
    //  V1.31 is  4.74.8793 - Minor update
    //  1.32  is  4.74.8875 - Windows ME+ IE5.5
    //  1.33  is  4.74.9273 - Windows XP+ IE6.0

  begin
    IF      I >= $4004A24390000 THEN Result := MakeLong(33,1) // 4.74.9273
    ELSE IF I >= $4004A22AB0000 THEN Result := MakeLong(32,1) // 4.74.8875
    ELSE IF I >= $4004A22590000 THEN Result := MakeLong(31,1) // 4.74.8793
    ELSE IF I >= $4004A21FE0000 THEN Result := MakeLong(3 ,1) // 4.74.8702
    ELSE IF I >= $4004921710000 THEN Result := MakeLong(22,1) // 4.73.8561
    ELSE IF I >= $40049211A0000 THEN Result := MakeLong(21,1) // 4.73.8474
    ELSE IF I >= $4004920DC0000 THEN Result := MakeLong(21,1) // 4.73.8412
    ELSE IF I >= $40049203C0000 THEN Result := MakeLong(2 ,1) // 4.73.8252
    ELSE IF I >= $400481FE40000 THEN Result := MakeLong(1 ,1) // 4.72.8164
    ELSE IF I >= $400481C9D0000 THEN Result := MakeLong(1 ,1) // 4.72.7325
    ELSE IF I >= $400481C7A0000 THEN Result := MakeLong(0 ,1) // 4.72.7290
    ELSE IF I >= $400481C9B0000 THEN Result := MakeLong(1 ,1) // 4.72.7323
    ELSE Result := 0;
  end;

begin
  // Get full pathname for the control
  filename := LocateHHCtrlOCX;
  IF filename = '' THEN Exit;
  HHLibHandle := LoadLibrary(PChar(filename));
  IF HHLibHandle = 0 THEN Exit;
  _HtmlHelp := GetProcAddress(HHLibHandle,
    MakeIntResource(ATOM_HTMLHELP_API_ANSI));
  VerSize := GetFileVersionInfoSize(PChar(filename), Dummy);
  IF VerSize > 0 THEN
    begin
      GetMem(Buffer, VerSize);
      try
        IF GetFileVersionInfo(PChar(Filename), Dummy, VerSize, Buffer) THEN
          begin
            IF VerQueryValue(Buffer, '\', Pointer(FFInfo), FFLen) THEN
              begin
                HHCtrlVersion := (Int64(FFInfo^.dwFileVersionMS) SHL 32) +
                  FFInfo^.dwFileVersionLS;
                HHVersion := Translate(HHCtrlVersion);
              end;
          end;
      finally
        FreeMem(Buffer);
      end;
    end;
end;

initialization
  InitializeHH;
finalization
  IF HHLibHandle <> 0 THEN
    FreeLibrary(HHLibHandle);
end.
