unit formposu; 

// Copyright  2002 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

// Often-used functions let a form remember its size and position
// from the previous session.

interface
uses Windows, SysUtils, Forms;

  procedure GetPosFmINI(const S : String; F : TForm; Siz : Boolean);
  procedure GetPosFmINIMax(const S : String; F : TForm;
    Siz : Boolean);
  procedure SetPosToINI(const S : String; F : TForm; Siz : Boolean);
  procedure GetPosFmEXEName(const S: String; F: TForm; Siz: Boolean);
  procedure GetPosFmEXENameMax(const S: String; F: TForm;
    Siz: Boolean);
  procedure SetPosToEXEName(const S: String; F: TForm; Siz: Boolean);

implementation
USES IniFiles;

procedure GetPosFmINI_internal(const S : String; F : TForm;
  Siz : Boolean; MaxOK : Boolean);
VAR
  R : TRect;
  TWP : TWindowPlacement;
begin
  SystemParametersInfo(SPI_GETWORKAREA, 0, @R, 0);
  // Center the form, in case its size/position aren't yet
  // in our INI file
  F.Left := R.Left + (((R.Right - R.Left) - F.Width) DIV 2);
  F.Top := R.Top + (((R.Bottom - R.Top) - F.Height) DIV 2);
  FillChar(TWP, SizeOf(TWP), 0);
  TWP.Length := SizeOf(TWP);
  GetWindowPlacement(F.Handle, @TWP);
  WITH TIniFile.Create(S) DO
  try
    WITH TWP.rcNormalPosition DO
      begin
        Left := ReadInteger(F.Name + ' Settings', 'Left', F.Left);
        Top := ReadInteger(F.Name + ' Settings', 'Top', F.Top);
        IF Siz THEN
          begin
            Right := ReadInteger(F.Name + ' Settings', 'Right', F.BoundsRect.Right);
            Bottom := ReadInteger(F.Name + ' Settings', 'Bottom', F.BoundsRect.Bottom);
          end
        ELSE
          begin
            Right := Left + F.Width;
            Bottom := Top + F.Height;
          end;
      end;
    WITH TWP.ptMinPosition DO
      begin
        X := ReadInteger(F.Name + ' Settings', 'MinX', X);
        Y := ReadInteger(F.Name + ' Settings', 'MinY', Y);
      end;
    WITH TWP.ptMaxPosition DO
      begin
        X := ReadInteger(F.Name + ' Settings', 'MaxX', X);
        Y := ReadInteger(F.Name + ' Settings', 'MaxY', Y);
      end;
    TWP.showCmd := SW_HIDE; // else trouble with ShowModal
    TWP.flags := ReadInteger(F.Name + ' Settings', 'flags',
      TWP.flags);
    IF Siz THEN
      WITH TWP, rcNormalPosition DO
        begin
          IF Right > R.Right THEN OffsetRect(rcNormalPosition, R.Right-Right, 0);
          IF Bottom > R.Bottom THEN OffsetRect(rcNormalPosition, 0, R.Bottom - Bottom);
          IF Left < 0 THEN Left := 0;
          IF Top < 0 THEN Top := 0;
        end;
    SetWindowPlacement(F.Handle, @TWP);
    IF MaxOK AND (ReadInteger(F.Name + ' Settings',
      'ShowCmd', 0) = SW_SHOWMAXIMIZED) THEN
      F.WindowState := wsMaximized;
  finally
    Free;
  end;
end;

procedure GetPosFmINIMax(const S : String; F : TForm; Siz : Boolean);
begin
  GetPosFmINI_internal(S, F, Siz, True);
end;

procedure GetPosFmINI(const S : String; F : TForm; Siz : Boolean);
begin
  GetPosFmINI_internal(S, F, Siz, False);
end;

procedure SetPosToINI(const S : String; F : TForm; Siz : Boolean);
VAR TWP : TWindowPlacement;
begin
  WITH TInIFile.Create(S) DO
  try
    FillChar(TWP, SizeOf(TWP), 0);
    TWP.Length := SizeOf(TWP);
    GetWindowPlacement(F.Handle, @TWP);
    WITH TWP.rcNormalPosition DO
      begin
        WriteInteger(F.Name + ' Settings', 'Left', Left);
        WriteInteger(F.Name + ' Settings', 'Top', Top);
        IF Siz THEN
          begin
            WriteInteger(F.Name + ' Settings', 'Right', Right);
            WriteInteger(F.Name + ' Settings', 'Bottom', Bottom);
          end;
      end;
    WITH TWP.ptMinPosition DO
      begin
        WriteInteger(F.Name + ' Settings', 'MinX', X);
        WriteInteger(F.Name + ' Settings', 'MinY', Y);
      end;
    WITH TWP.ptMaxPosition DO
      begin
        WriteInteger(F.Name + ' Settings', 'MaxX', X);
        WriteInteger(F.Name + ' Settings', 'MaxY', Y);
      end;
    WriteInteger(F.Name + ' Settings', 'ShowCmd',
      TWP.showCmd);
    WriteInteger(F.Name + ' Settings', 'flags',
      TWP.flags);
  finally
    Free;
  end;
end;

procedure GetPosFmEXEName(const S: String; F: TForm; Siz: Boolean);
begin
  GetPosFmINI(ChangeFileExt(S, '.INI'), F, Siz);
end;

procedure GetPosFmEXENameMax(const S: String; F: TForm;Siz: Boolean);
begin
  GetPosFmINIMax(ChangeFileExt(S, '.INI'), F, Siz);
end;

procedure SetPosToEXEName(const S: String; F: TForm; Siz: Boolean);
begin
  SetPosToINI(ChangeFileExt(S, '.INI'), F, Siz);
end;

end.
