unit autowhau;

// Copyright  2002 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

//TODO: Install location "PC Magazine Utilities"

//TODO: Refresh list loses checks

//TODO: Code review
//TODO: New icon?
//TODO: New help

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, CheckLst, OleCtrls, SHDocVw,
  ComCtrls, AppEvnts;

type
  TMainForm = class(TForm)
    pnlButtons: TPanel;
    sbMain: TStatusBar;
    Label1: TLabel;
    pnlList: TPanel;
    pnlNT: TPanel;
    pnlOld: TPanel;
    lbMain: TCheckListBox;
    btnChange: TButton;
    btnConfigure: TButton;
    btnRefresh: TButton;
    btnHelp: TButton;
    btnCkAll: TButton;
    btnAbout: TButton;
    btnClAll: TButton;
    btnClose: TButton;
    ApplicationEvents1: TApplicationEvents;
    procedure FormCreate          (Sender: TObject);
    procedure FormDestroy         (Sender: TObject);
    procedure FormKeyPress        (Sender: TObject; var Key: Char);
    procedure lbMainClickCheck  (Sender: TObject);
    procedure lbMainDblClick    (Sender: TObject);
    procedure lbMainDragOver    (Sender, Source: TObject;
      X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure btnChangeClick      (Sender: TObject);
    procedure btnConfigureClick   (Sender: TObject);
    procedure btnRefreshClick     (Sender: TObject);
    procedure btnCkAllClick       (Sender: TObject);
    procedure btnHelpClick        (Sender: TObject);
    procedure btnAboutClick       (Sender: TObject);
    procedure btnCloseClick       (Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ApplicationEvents1Hint(Sender: TObject);
    procedure pnlButtonsMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
    tempFiles : TStringList;
//    theKey : String;
    tempName : String;
    first : Boolean;
    IEMajor, IEMinor : DWord;
    helper : String;
    function NumChecked : Integer;
    procedure LoadList;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation
uses Registry, ShellApi, AboutBox, allfuncs, formposu, autoShar;
{$R *.DFM}


const
  RegKey : String = 'SOFTWARE\Microsoft\Protected Storage System Pr'+
    'ovider\%s\Data\e161255a-37c3-11d2-bcaa-00c04fd929db\e161255a-3'+
    '7c3-11d2-bcaa-00c04fd929db';

  templateHead : String =
    '<HTML>'+
    '<HEAD>'+
    '<TITLE>AutoWhat Test Page </TITLE>'+
    '</HEAD>'+
    '<BODY>'+
    '<H1 ALIGN="CENTER">AutoWhat Test Page</H1>'+
    '<P>AutoComplete values for fields in Web-based forms are '+
    'tied to the internal field name. The table below lists '+
    'the selected internal field names for which AutoComplete '+
    'values have been recorded.</P>'+
    '<UL>'+
    '<LI>To see the drop-down list of AutoComplete values for '+
    'a particular field name, click in the blank input field next '+
    'to it and press the down arrow. </LI>'+
    '<LI>To delete one of these entries, highlight it in the '+
    'drop-down list and press the Del key. </LI>'+
    '<LI>To add a new value to the list for a particular '+
    'field name, type it into the adjacent input field and '+
    'click Post or press Enter.</LI>'+
    '<LI>You can add multiple items for a given field name '+
    'by repeating this process.</LI>'+
    '</UL>'+
    '<FORM>'+
    '<INPUT TYPE="submit" NAME="Submit" VALUE="Post"><BR><BR>'+
    '<TABLE BORDER="1" RULES="ROWS" CELLPADDING="2">'+
    '<TR>'+
    '<TH NOWRAP="NOWRAP" ALIGN="LEFT">Internal field names</TH>'+
    '<TH NOWRAP="NOWRAP" ALIGN="LEFT">Input fields</TH>'+
    '</TR>';

  templateLine : String =
    '<TR>'+
    '<TD NOWRAP="NOWRAP">%s</TD>'+
    '<TD NOWRAP="NOWRAP"><INPUT NAME="%0:s" SIZE="50"></TD>'+
    '</TR>';
  templateFoot : String =
    '</TABLE>'+
    '<BR>'+
    '<INPUT TYPE="submit" NAME="Submit" VALUE="Post">&nbsp;'+
    '</FORM>'+
    '<HR SIZE=3>'+
    '<FONT SIZE="2">AutoWhat Copyright &copy; 1999, 2002 by '+
    'Ziff-Davis, Inc.<BR>All Rights Reserved<BR></FONT>'+
    '<FONT SIZE="1">Written by Neil J. Rubenking<BR>'+
    'First published in <A HREF="http://www.pcmextra.com">'+
    'PC Magazine, U.S. Edition</A>, Monthuary 32, 2002.</FONT>'+
    '</BODY>'+
    '</HTML>';


procedure TMainForm.FormCreate(Sender: TObject);
begin
  IF Win32Platform = VER_PLATFORM_WIN32_NT THEN
    begin
      helper := ExtractFileDir(Application.Exename) +
        '\AutoServ.exe';
      WinExec(PChar(helper+' /install /silent'), SW_MINIMIZE);
    end;
  first := True;
  TempName := ChangeFileExt(Application.Exename, '.$$$');
  IF Win32Platform = VER_PLATFORM_WIN32_NT THEN
    PutShared(TempName);
  pnlOld.Height := lbMain.Height;
  pnlNT.Height  := lbMain.Height;
  Application.HelpFile := ChangeFileExt(Application.ExeName, '.HLP');
  TempFiles := TStringList.Create;
  GetPosFmExeName(Application.ExeName, Self, False);
end;

procedure TMainForm.FormDestroy(Sender: TObject);
VAR N : Integer;
begin
  IF Win32Platform = VER_PLATFORM_WIN32_NT THEN
    WinExec(PChar(helper+' /uninstall /silent'), SW_MINIMIZE);

  FOR N := 0 TO TempFiles.Count-1 DO
    DeleteFile(TempFiles[N]);
  TempFiles.Free;
  SetPosToExeName(Application.ExeName, Self, False);
end;

procedure TMainForm.FormKeyPress(Sender: TObject; var Key: Char);
// Because the buttons are all flat speedbuttons, they can't
// be assigned the Default or Cancel properties. This method
// causes Esc to close the form and Enter to activate btnChange
begin
  IF Key = #27 THEN Close
  ELSE IF Key = #13 THEN btnChangeClick(btnChange)
  ELSE Exit;
  Key := #0;
end;

procedure TMainForm.lbMainClickCheck(Sender: TObject);
VAR N : Integer;
begin
  btnChange.Enabled := True;
  WITH Sender AS TCheckListBox DO
    FOR N := 0 TO Items.Count-1 DO
      IF Checked[N] THEN
        Exit;
  // Next line only executed if NO items are checked
  btnChange.Enabled := False;
end;

procedure TMainForm.lbMainDblClick(Sender: TObject);
// Toggle checked state upon double-click
VAR N : Integer;
begin
  WITH Sender AS TCheckListBox DO
    IF ItemIndex > -1 THEN
      Checked[ItemIndex] := NOT Checked[ItemIndex];
  btnChange.Enabled := True;
  WITH Sender AS TCheckListBox DO
    FOR N := 0 TO Items.Count-1 DO
      IF Checked[N] THEN
        Exit;
  // Next line only executed if NO items are checked
  btnChange.Enabled := False;
end;

procedure TMainForm.lbMainDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
// This method causes items in the list to be checked if you click
// on any item and drag along
VAR Idx : Integer;
begin
  Accept := Sender=Source;
  WITH Sender AS TCheckListBox DO
    begin
      Idx := ItemAtPos(Point(X,Y), True);
      IF Idx > -1 THEN
        begin
          Checked[Idx] := True;
          ItemIndex := Idx;
          btnChange.Enabled := True;
        end;
    end;
end;

procedure TMainForm.btnChangeClick(Sender: TObject);
VAR
  fn : String;
  T  : TextFile;
  N  : Integer;

  function GetTempHTMName : String;
  VAR
    tempP : ARRAY[0..MAX_PATH] OF Char;
    N     : Integer;
  begin
    GetTempPath(MAX_PATH, tempP);
    Result := FinalSlash(StrPas(TempP));
    N := GetTickCount AND $FFFF;
    WHILE FileExists(Result+Format('auto%.04x.htm', [N])) DO Inc(N);
    Result := Result + Format('auto%.04x.htm', [N]);
  end;

begin
  // Next line should not be needed; button should be disabled if
  // not WinNT and no items checked. But just in case...
  IF (NOT IsWinNT) AND (NumChecked = 0) THEN Exit;
  Screen.Cursor := crAppStart;
  try
    fn := GetTempHTMName;
    tempFiles.Add(fn);
    AssignFile(T, fn);
    Rewrite(T);
    try
      WriteLn(T, TemplateHead);
      FOR N := 0 TO lbMain.Items.Count-1 DO
        IF lbMain.Checked[N] THEN
          WriteLn(T, Format(templateLine, [lbMain.Items[N]]));
      WriteLn(T, TemplateFoot);
    finally
      CloseFile(T);
    end;
    ShellExecute(Self.Handle, 'open', PChar(fn), nil, nil, SW_RESTORE);
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TMainForm.btnConfigureClick(Sender: TObject);
VAR
  hDial, hTab, hButn : HWnd;
  ID, N : Integer;
begin
  IF IEMajor >= 6 THEN
  WinExec('rundll32 shell32.dll,Control_RunDLL inetcpl.cpl,@0,3',
    SW_SHOWNORMAL)
  ELSE
  WinExec('rundll32 shell32.dll,Control_RunDLL inetcpl.cpl,@0,2',
    SW_SHOWNORMAL);
  N := 0;
  REPEAT
    hDial := FindWindow('#32770', 'Internet Properties');
    IF hDial <> 0 THEN Break;
    Sleep(500);
    Inc(N);
  UNTIL N >= 10;
  IF hDial = 0 THEN
    begin
      MessageBox(Handle, 'Please note the precise caption '+
        'of the dialog box that was just launched, and report '+
        'to Neil. Thanks!', 'AutoWhat? BETA', MB_OK OR
        MB_ICONINFORMATION);
      Exit;
    end;
  hTab := FindWIndowEx(hDial, 0, '#32770', 'Content');
  hButn := FindWindowEx(hTab, 0, 'Button', 'A&utoComplete...');
  ID := GetDlgCtrlID(hButn);
  PostMessage(hDial, WM_COMMAND, ID, hButn);
end;

procedure TMainForm.btnRefreshClick(Sender: TObject);
begin
  LoadList;
end;

procedure TMainForm.btnCkAllClick(Sender: TObject);
// Check all or none, depending if tag is 1 or 0
VAR N : Integer;
begin
  WITH Sender AS TButton DO
    begin
      FOR N := 0 TO lbMain.Items.Count-1 DO
        lbMain.Checked[N] := Tag=1;
      btnChange.Enabled := (lbMain.Items.Count > 0) AND (Tag=1);
    end;
end;

procedure TMainForm.btnHelpClick(Sender: TObject);
begin
  IF NOT IsWindow(HtmlHelp(Handle, PChar(ChangeFileExt(Application.Exename, '.chm')),
    0,0)) THEN
    MessageBox(Handle, 'AutoWhat? failed to invoke HtmlHelp',
      'AutoWhat?', MB_OK OR MB_ICONSTOP);

//  Application.HelpCommand(HELP_FINDER, 0);
end;

procedure TMainForm.btnAboutClick(Sender: TObject);
begin
  WITH TAboutForm.Create(Self) DO
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TMainForm.btnCloseClick(Sender: TObject);
begin
  Close;
end;

function TMainForm.NumChecked: Integer;
VAR N : Integer;
begin
  Result := 0;
  FOR N := 0 TO lbMain.Items.Count-1 DO
    IF lbMain.Checked[N] THEN
      Inc(Result);
end;

procedure TMainForm.LoadList;
VAR
  TS        : TStringList;
  N, P, Idx : Integer;

  procedure ReadRegNT;
  begin
    IF StartAndStop <> sands_OK THEN
      MessageBox(Handle, 'AutoWhat was unable to activate its '+
        'helper service. You may have uninstalled the service. '+
        'Reinstall AutoWhat, or open a command prompt, navigate '+
        'to the folder containing AutoWhat, and issue the command '+
        '"autoserv /install" (no quotes)', 'AutoWhat',
        MB_OK OR MB_ICONSTOP)
    ELSE
      begin
        TS.LoadFromFile(tempName);
        DeleteFile(tempName);
      end;
  end;

  procedure ReadReg9x;
  VAR
    nSize    : Cardinal;
    buffer   : ARRAY[0..MAX_PATH] OF Char;
    UserName : String;
    TempS    : TStringList;
  begin
    nSize := MAX_PATH;
    GetuserName(buffer, nSize);
    UserName := Strpas(Buffer);
    WITH TRegistry.Create DO
    try
      Rootkey := HKEY_LOCAL_MACHINE;
      IF OpenKey(Format(RegKey, [UserName]), False) THEN
        GetKeyNames(TS);
      //IE6 under Win9x puts it here?
      Rootkey := HKEY_CURRENT_USER;
      IF OpenKey(Format(RegKey, [UserName]), False) THEN
        begin
          TempS := TStringList.Create;
          try
            GetKeyNames(TempS);
            TS.Duplicates := dupIgnore;
            TS.Sorted := True;
            TS.AddStrings(TempS);
            TS.Sorted := False;
            TS.Duplicates := dupAccept;
          finally
            TempS.Free;
          end;
        end;
    finally
      Free;
    end;
  end;

begin
  lbMain.Enabled     := False;
  btnRefresh.Enabled   := False;
  btnChange.Enabled    := False;
  btnCkAll.Enabled     := False;
  btnClAll.Enabled     := False;

  TS := TStringList.Create;
  Screen.Cursor := crHourglass;
  try
    IF Win32Platform = VER_PLATFORM_WIN32_NT THEN
      ReadRegNT
    ELSE
      ReadReg9x;
    // Remove any useless items from TS; trim useful ones
    FOR N := TS.Count-1 DOWNTO 0 DO
      begin
        Application.ProcessMessages;
        P := Pos(':StringData', TS[N]);
        IF (P = 0) OR (Pos('/', TS[N]) <> 0) THEN
          TS.Delete(N)
        ELSE TS[N] := Copy(TS[N], 1, P-1);
      end;
    //Save checked info
    FOR N := 0 TO TS.Count-1 DO
      begin
        P := lbMain.Items.IndexOf(TS[N]);
        IF P < 0 THEN Continue;
        IF lbMain.Checked[P] THEN
          TS.Objects[N] := Pointer(1);
      end;
    Idx := lbMain.ItemIndex;
    lbMain.Clear;
    lbMain.Items.AddStrings(TS);
    //Restore checked info
    FOR N := 0 TO lbMain.Items.Count-1 DO
      lbMain.Checked[N] :=
        (lbMain.Items.Objects[N] = Pointer(1));
    IF Idx >= lbMain.Items.Count THEN Idx := lbMain.Items.Count-1;
    lbMain.ItemIndex := Idx;
    btnCkAll.Enabled  := lbMain.Items.Count > 0;
    btnClAll.Enabled  := lbMain.Items.Count > 0;
    btnChange.Enabled := NumChecked > 0;

    lbMain.Enabled     := True;
    btnRefresh.Enabled   := True;
  finally
    TS.Free;
    Screen.Cursor := crDefault;
    lbMain.ItemIndex := -1;
  end;
end;

procedure TMainForm.FormActivate(Sender: TObject);
  function ShlWapiIs5_00 : boolean;
  type
    PDllVersionInfo = ^TDllVersionInfo;
    TDllVersionInfo = record
      cbSize          : DWORD;
      dwMajorVersion  : DWORD;
      dwMinorVersion  : DWORD;
      dwBuildNumber   : DWORD;
      dwPlatformID    : DWORD;
    end;
    DllGetVersionType = function (pdvi : PDllVersionInfo) :
      HRESULT; stdcall;
  VAR
    LibH           : hModule;
    DllGetVersion  : DllGetVersionType;
    DVI            : TDllVersionInfo;
  begin
    IEMajor := 0;
    IEMinor := 0;
    Result := False;
    LibH   := LoadLibrary('shlwapi.dll');
    IF LibH <= 32 THEN Exit;
    try
      @DllGetVersion := GetProcAddress(LibH, 'DllGetVersion');
      IF @DllGetVersion = nil THEN Exit;
      FillChar(DVI, SizeOf(DVI), 0);
      DVI.cbSize := SizeOf(DVI);
      IF DllGetVersion(@DVI) = NOERROR THEN
        begin
          IEMajor := DVI.dwMajorVersion;
          IEMinor := DVI.dwMinorVersion;
          IF DVI.dwMajorVersion >= 5 THEN Result := True;
        end;
    finally
      FreeLibrary(LibH);
    end;
  end;

begin
  IF NOT First THEN Exit;
  First := False;
  Show;
  Application.ProcessMessages;
  IF NOT ShlWapiIs5_00 THEN
    begin
      PnlOld.BringToFront;
    end
  ELSE
    begin
      LoadList;
    end;

end;

procedure TMainForm.ApplicationEvents1Hint(Sender: TObject);
begin
  sbMain.SimpleText := Application.Hint;
end;

procedure TMainForm.pnlButtonsMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
// This enables flyover hints for disabled buttons
VAR
  P : TPoint;
  N : Integer;
begin
  P := Point(X,Y);
  WITH Sender AS TWinControl DO
    begin
      Hint := '';
      FOR N := 0 TO ControlCount-1 DO
        IF Controls[N] IS TWinControl THEN
          IF PtInRect(TWinControl(Controls[N]).BoundsRect, P) THEN
            Hint := TWinControl(Controls[N]).Hint;
      IF Hint = '' THEN
        Application.CancelHint;
    end;
end;

end.




