unit autosrvu;

// Copyright  2002 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

// AutoWhat? needs access to a specific Registry key. In Windows
// NT-family, this key's permissions include only SYSTEM, not even
// the Administrators group. Rather than try to change the key's
// permissions, AutoWhat? relies on this service (which runs with
// SYSTEM permissions) to get the desired information.

// THANKS to Marcel van Brakel for suggesting the use of a service
// to get around this thorny problem.

interface

uses
  Windows, Classes, SvcMgr, SysUtils, verresu;

type
  TAutoWhatService = class(TService)
    procedure ServiceExecute(Sender: TService);
    procedure ServiceAfterInstall(Sender: TService);
  private
    { Private declarations }
    function VerString : String;
  public
    function GetServiceController: TServiceController; override;
    { Public declarations }
  end;

var
  AutoWhatService: TAutoWhatService;

implementation
USES Registry, autoShar, strUtils;
{$R *.DFM}

procedure ServiceController(CtrlCode: DWord); stdcall;
begin
  AutoWhatService.Controller(CtrlCode);
end;

function TAutoWhatService.GetServiceController: TServiceController;
begin
  Result := ServiceController;
end;

procedure TAutoWhatService.ServiceAfterInstall(Sender: TService);
// In the Windows NT4/2000/XP Services applet, each service can
// have an optional description. This method, invoked after the
// AutoWhatService is installed, supplied that description.
begin
  WITH TRegistry.Create DO
  try
    RootKey := HKEY_LOCAL_MACHINE;
    IF OpenKey('\SYSTEM\ControlSet001\Services\AutoWhatService',
      False) THEN
      WriteString('Description', 'Used by PC Magazine''s AutoWhat '+
        'utility to retrieve proteced Registry data');
  finally
    Free;
  end;
end;

procedure TAutoWhatService.ServiceExecute(Sender: TService);
// This event handler is triggered when the service starts. To get
// the desired information, AutoWhat? starts and stops the service.
VAR
  Reg      : TRegistry;
  KeyNames : TStrings;
  fSID     : String;
  N        : Integer;
  Line     : Integer;
begin
                                         Line := 00;
  try
    Reg := TRegistry.Create;             Line := 01;
    KeyNames := TStringList.Create;      Line := 02;
    try
      Reg.RootKey := HKEY_USERS;         Line := 03;
      // The service needs to read data from HKEY_CURRENT_USER. However
      // because it runs as SYSTEM it does not have direct access to
      // that key. It must locate the subkey of HKEY_USERS that matches
      // the current user's Security ID (SID). Again because it runs as
      // SYSTEM, it's difficult to get that SID. It's very simple
      // for the main AutoWhat? program to get that information,
      // though. So AutoWhat? obtains the SID and stores it in a key
      // under HKLM, where the service can easily access it.
      GetShared(fSid);                   Line := 04;
      IF fSid = '' THEN
        Raise(Exception.Create('AutoServ did not receive a SID from '+
          'AutoWhat?. Note that AutoServ cannot be used independently '+
          'of AutoWhat?.'));
                                         Line := 05;
      IF NOT Reg.OpenKeyReadOnly(fSID+'\SOFTWARE\Microsoft\Protected '+
        'Storage System Provider') THEN
          Raise(Exception.Create('Unable to open HKEY_USERS\'+fSid));
                                         Line := 06;
      IF NOT Reg.OpenKeyReadOnly(fSid + '\Data\e161255a-37c3-11d2-'+
        'bcaa-00c04fd929db\e161255a-37c3-11d2-bcaa-00c04fd929db') THEN
          Raise(Exception.Create('Unable to open data key ('+fSid +
          '\Data\e161255a-37c3-11d2-bcaa-00c04fd929db\'+
          'e161255a-37c3-11d2-bcaa-00c04fd929db)'));
                                         Line := 07;
      Reg.GetKeyNames(KeyNames);         Line := 08;
      Reg.CloseKey;                      Line := 09;
      Reg.RootKey := HKEY_LOCAL_MACHINE; Line := 10;
      Reg.OpenKey(fromKey, True);        Line := 11;
      FOR N := 0 TO KeyNames.Count-1 DO
        IF NOT AnsiStartsText('http:', KeyNames[N]) THEN
        try       // This was failing sometimes 1.0.7.0 fix?
          Reg.CreateKey(keyNames[N]);
        except
          On Exception DO;
        end;                             Line := 12;
      Reg.CreateKey('AutoServFinished'); Line := 13;
    finally
      Reg.CloseKey;
      KeyNames.Free;
      Reg.Free;
      ServiceThread.ProcessRequests(True);
    end;
  except
    ON E:Exception DO
      LogMessage(Format(#13#10'AutoServe version %s'#13#10+
      'Exception: %s'#13#10'System message: %s'#13#10+
      'Line: %d', [VerString, E.Message,
      SysErrorMessage(GetLastError), Line]), EVENTLOG_ERROR_TYPE);
  end;
end;

function TAutoWhatService.VerString: String;
begin
  WITH TVerInfoObj.Create(ParamStr(0)) DO
  try
    Result := FileVersion;
  finally
    Free;
  end;
end;

end.

