unit autoShar;

// Copyright  2002 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

// Contains functions used by AutoServ and AutoWhat? to share data

interface
USES Windows, SysUtils;

procedure putShared;
function GetShared(VAR vSid : String) : Integer;

const
  ToKey =   '\SOFTWARE\PC Magazine Utilities\AutoWhat\ToService';
  FromKey = '\SOFTWARE\PC Magazine Utilities\AutoWhat\FromService';
  // Format string for Registry key that stores AutoComplete data
  // "%s" is replaced by username in Win9x, SID in NT-family
  RegKey : String = 'SOFTWARE\Microsoft\Protected Storage System Pr'+
    'ovider\%s\Data\e161255a-37c3-11d2-bcaa-00c04fd929db\e161255a-3'+
    '7c3-11d2-bcaa-00c04fd929db';

  cus_OK                        = 0;
  cus_GetUserName               = -1;
  cus_LookupAccountName         = -2;
  cus_GetSidIdentifierAuthority = -3;
  cus_GetSidSubAuthorityCount   = -4;
  cus_GetSidSubAuthority        = -5;
  cus_GetShareFailed            = -6;

implementation
uses Registry;

type
  TOKEN_USER = packed record
    User : TSidAndAttributes;
  end;
  PTOKEN_USER = ^TOKEN_USER;

VAR SIDBUFF : ARRAY[0..1000] OF Byte;

function CurrentUserSID(VAR theSID : String) : Integer;
// Calculate the Security ID for the current user, to
//  determine which branch of HKEY_USERS is HKEY_CURRENT_USER
//
// This is an updated version of a function to get the Security ID
// for the current user. The previous version used GetUserName and
// LookupAccountName to get the SID. In some situations, this gave
// the wrong SID. The new version uses GetCurrentProcess and
// GetProcessToken, which seems to work consistently.
//
// In addition, the old version was mistakenly formatting SID
// sub-authorities using %d (signed integer) rather than %u
// (unsigned integer). For the occasional sub-authority with a
// value greater than MaxInt, this resulted in creation of an
// erroneous string for the SID. Also fixed.
VAR
  hProcess, hAccessToken : THandle;
  dwSIDSize : DWORD;
  Sid       : PSid;
  PSIA     : PSIDIdentifierAuthority;
//NOTE: Fix for unsigned-integer error
//  N        : Integer;
  N        : DWORD;
  NumSubs  : PUChar;
  OneSub   : PDWORD;
begin
  Result   := -1;
  hProcess := 0;
  hAccessToken := 0;
  FillChar(SIDBUFF, SizeOf(SIDBUFF), 0);
  hProcess := GetCurrentProcess;
  IF NOT OpenProcessToken(hProcess, TOKEN_READ, hAccessToken) THEN
    Exit;
  Result := -2;
  dwSidSize := SizeOf(SIDBUFF);
  IF NOT GetTokenInformation(hAccessToken, TokenUser, @SIDBUFF,
    SizeOf(SIDBUFF), dwSIDSize) THEN Exit;
  Result := -3;
  TheSid := 'S-1-';
  SetLastError(0);
  Sid := PToken_User(@SIDBUFF).User.SID;
  IF NOT IsValidSid(Sid) THEN
    Exit;
  PSIA := GetSidIdentifierAuthority(sid);
  IF GetLastError <> 0 THEN
    Exit;
  WITH PSIA^ do
    IF (Value[0]<>0) OR (Value[1]<>0) THEN
      TheSid := Format('%s0x%.2x%.2x%.2x%.2x%.2x%.2x-',
        [TheSid, Value[0], Value[1], Value[2], Value[3],
        Value[4], Value[5]])
    else
      begin
        N := Value[2] SHL 8;
        N := (N + Value[3]) SHL 8;
        N := (N + Value[4]) SHL 8;
        N := N + Value[5];
//NOTE: Fix for unsigned-integer error
//        TheSid := Format('%s%d', [TheSid, N]);
        TheSid := Format('%s%u', [TheSid, N]);
      end;
  Result  := cus_GetSidSubAuthorityCount;
  NumSubs := GetSidSubAuthorityCount(sid);
  IF GetLastError <> 0 THEN
    Exit;
  FOR N := 0 TO NumSubs^-1 DO
    begin
      Result := cus_GetSidSubAuthority;
      OneSub := GetSidSubAuthority(sid, N);
      IF GetLastError <> 0 THEN
        Exit;
//NOTE: Fix for unsigned-integer error
//      TheSid := Format('%s-%d', [TheSid, OneSub^]);
      TheSid := Format('%s-%u', [TheSid, OneSub^]);
    end;
  Result := cus_OK;
end;

(*function CurrentUserSIDOld(VAR theSID : String) : Integer;
// Calculate the Security ID for the current user, to
//  determine which branch of HKEY_USERS is HKEY_CURRENT_USER
//
// This function is replaced by CurrentUserSID, above. It is not
// used in the program. However, it has been updated to eliminate
// the unsigned-integer problem described above.
VAR
  UserName : ARRAY[0..MAX_PATH] OF Char;
  UserLeng : DWORD;
  DomaName : ARRAY[0..MAX_PATH] OF Char;
  DomaLeng : DWORD;
  SID      : ARRAY[0..1000] OF Byte;
  SIDLeng  : DWORD;
  SIDuse   : DWORD;
  PSIA     : PSIDIdentifierAuthority;
  N        : Integer;
  NumSubs  : PUChar;
  OneSub   : PDWORD;
begin
  UserLeng := MAX_PATH;
  Result   := cus_GetUserName;
  IF NOT GetUserName(UserName, UserLeng) THEN
    Exit;
  DomaLeng := MAX_PATH;
  Result   := cus_LookupAccountName;
  SidLeng  := 1000;
  IF NOT LookupAccountName(NIL, UserName, @SID, SIDLeng,
    DomaName, DomaLeng, SidUse) THEN
    Exit;
  TheSid := 'S-1-';
  Result := cus_GetSidIdentifierAuthority;
  SetLastError(0);
  PSIA := GetSidIdentifierAuthority(@SID);
  IF GetLastError <> 0 THEN
    Exit;
  WITH PSIA^ do
    IF (Value[0]<>0) OR (Value[1]<>0) THEN
      TheSid := Format('%s0x%.2x%.2x%.2x%.2x%.2x%.2x-',
        [TheSid, Value[0], Value[1], Value[2], Value[3],
        Value[4], Value[5]])
    else
      begin
        N := Value[2] SHL 8;
        N := (N + Value[3]) SHL 8;
        N := (N + Value[4]) SHL 8;
        N := N + Value[5];
//NOTE: Fix for unsigned-integer error
//        TheSid := Format('%s%d', [TheSid, N]);
        TheSid := Format('%s%u', [TheSid, N]);
      end;
  Result  := cus_GetSidSubAuthorityCount;
  NumSubs := GetSidSubAuthorityCount(@SID);
  IF GetLastError <> 0 THEN
    Exit;
  FOR N := 0 TO NumSubs^-1 DO
    begin
      Result := cus_GetSidSubAuthority;
      OneSub := GetSidSubAuthority(@SID, N);
      IF GetLastError <> 0 THEN
        Exit;
//NOTE: Fix for unsigned-integer error
//      TheSid := Format('%s-%d', [TheSid, OneSub^]);
      TheSid := Format('%s-%u', [TheSid, OneSub^]);
    end;
  Result := cus_OK;
end;*)

procedure putShared;
// AutoWhat? uses this routine to put the current user's SID in a
// Registry key that's easily read by AutoServ (i.e. one in HKLM)
VAR SID : String;
begin
  WITH TRegistry.Create DO
  try
    RootKey := HKEY_LOCAL_MACHINE;
    IF OpenKey(ToKey, True) THEN
      begin
        WriteInteger('Status', CurrentUserSid(SID));
        WriteString('fSid', SID);
        CloseKey;
      end;
  finally
    Free;
  end;
end;

function GetShared(VAR vSid : String) : Integer;
// AutoServ grabs the current user's SID from a key under HKLM, where
// AutoWhat? placed it. It then deletes the key
begin
  Result := cus_GetShareFailed;
  vSid := '';
  WITH TRegistry.Create DO
  try
    RootKey := HKEY_LOCAL_MACHINE;
    IF OpenKey(ToKey, False) THEN
      begin
        vSid := ReadString('fSid');
        Result := ReadInteger('Status');
        CloseKey;
        DeleteKey(ToKey);
      end;
  finally
    Free;
  end;
end;

end.

