unit AboutBox;

// Copyright  2002 by Ziff Davis Media, Inc.
// Written by Neil J. Rubenking

// Standard re-usable about-box. Gets the program name from
// the application object's Title field, and reads version and
// copyright information from the version resource. If the
// version resource is marked "pre-release", it adds "beta"
// to the name and puts the version label in red print.
// If a bitmap resource named ABOUTME is present, it displays
// it. (This is assumed to be a 48x48 bitmap). If not it
// displays the application's icon.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, ExtCtrls, StdCtrls, Buttons;

type
  TAboutForm = class(TForm)
    lblVersion   : TLabel;
    lblCopyright : TLabel;
    Panel1       : TPanel;
      Image1     : TImage;
    lblPubdate: TLabel;
    lblAuthor: TLabel;
    btnAboutOK: TButton;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    VerStr, CopStr, AuthStr, PubStr : String;
    PreRel                 : Boolean;
    procedure GetVersionData;
  public
    { Public declarations }
  end;

var
  AboutForm: TAboutForm;

implementation
USES VerResU;
{$R *.DFM}

procedure TAboutForm.GetVersionData;
begin
  WITH TVerInfoObj.Create(Application.ExeName) DO
  try
    PreRel := VFFI.dwFileFlags AND VS_FF_PRERELEASE > 0;
    VerStr := Values['FileVersion'];
    IF VerStr = '' THEN
      IF PreRel THEN
        VerStr := Application.Title + ' beta'
      ELSE VerStr := Application.Title
    ELSE
      IF PreRel THEN
        VerStr := Format('%s - beta version %s',
          [Application.Title, VerStr])
      ELSE
        VerStr := Format('%s - version %s',
          [Application.Title, VerStr]);
    CopStr := Values['LegalCopyright'];
    IF CopStr = '' THEN
      CopStr := 'Copyright  2000 Ziff Davis Media, inC.';
    AuthStr := Values['Comments'];
    IF AuthStr = '' THEN
      AuthStr := 'Written by Neil J. Rubenking';
    PubStr := Values['PubDate'];
    IF PubStr = '' THEN
      PubStr := 'Monthuary 32, 2001';
  finally
    Free;
  end;
end;

procedure TAboutForm.FormCreate(Sender: TObject);
begin
  GetVersionData;
  Caption := 'About ' + Application.Title;
  Image1.Picture.Bitmap.LoadFromResourceName(hinstance, 'AboutMe');
  IF Image1.Picture.Bitmap.Handle = 0 THEN
    begin
      Image1.Picture.Icon := Application.Icon;
      Image1.Center := True;
    end;
  IF PreRel THEN lblVersion.Font.Color := clRed;
  lblVersion.Caption := VerStr;
  lblCopyright.Caption := CopStr;
  lblAuthor.Caption := AuthStr;
  lblPubdate.Caption := PubStr;
end;

end.




